/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ParameterFilterInterceptor
implements Interceptor {
    private Collection allowed;
    private Collection blocked;
    private TreeMap includesExcludesMap;
    private boolean defaultBlock = false;

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Map parameters = invocation.getInvocationContext().getParameters();
        HashSet<String> paramsToRemove = new HashSet<String>();
        TreeMap includesExcludesMap = this.getIncludesExcludesMap();
        Iterator<Object> i = parameters.keySet().iterator();
        while (i.hasNext()) {
            String param = (String)i.next();
            boolean currentAllowed = !this.isDefaultBlock();
            boolean foundApplicableRule = false;
            Iterator j = includesExcludesMap.keySet().iterator();
            while (j.hasNext()) {
                String currRule = (String)j.next();
                if (param.startsWith(currRule) && (param.length() == currRule.length() || this.isPropSeperator(param.charAt(currRule.length())))) {
                    currentAllowed = (Boolean)includesExcludesMap.get(currRule);
                    continue;
                }
                if (!foundApplicableRule) continue;
                foundApplicableRule = false;
                break;
            }
            if (currentAllowed) continue;
            paramsToRemove.add(param);
        }
        i = paramsToRemove.iterator();
        while (i.hasNext()) {
            parameters.remove(i.next());
        }
        return invocation.invoke();
    }

    private boolean isPropSeperator(char c) {
        return c == '.' || c == '(' || c == '[';
    }

    private TreeMap getIncludesExcludesMap() {
        if (this.includesExcludesMap == null) {
            Iterator i;
            this.includesExcludesMap = new TreeMap();
            if (this.getAllowed() != null) {
                i = this.getAllowed().iterator();
                while (i.hasNext()) {
                    this.includesExcludesMap.put(i.next(), Boolean.TRUE);
                }
            }
            if (this.getBlocked() != null) {
                i = this.getBlocked().iterator();
                while (i.hasNext()) {
                    this.includesExcludesMap.put(i.next(), Boolean.FALSE);
                }
            }
        }
        return this.includesExcludesMap;
    }

    public boolean isDefaultBlock() {
        return this.defaultBlock;
    }

    public void setDefaultBlock(boolean defaultExclude) {
        this.defaultBlock = defaultExclude;
    }

    public Collection getBlocked() {
        return this.blocked;
    }

    public void setBlocked(Collection blocked) {
        this.blocked = blocked;
    }

    public void setBlocked(String blocked) {
        this.setBlocked(this.asCollection(blocked));
    }

    public Collection getAllowed() {
        return this.allowed;
    }

    public void setAllowed(Collection allowed) {
        this.allowed = allowed;
    }

    public void setAllowed(String allowed) {
        this.setAllowed(this.asCollection(allowed));
    }

    private Collection asCollection(String commaDelim) {
        if (commaDelim == null || commaDelim.trim().length() == 0) {
            return null;
        }
        String[] splitString = commaDelim.split(",");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < splitString.length; ++i) {
            set.add(splitString[i].trim());
        }
        return set;
    }
}

