/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.providers;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.util.FileManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.ConfigurationUtil;
import com.opensymphony.xwork.config.ExternalReferenceResolver;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork.config.entities.ExternalReference;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import com.opensymphony.xwork.config.providers.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlConfigurationProvider
implements ConfigurationProvider {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider == null ? (class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider = XmlConfigurationProvider.class$("com.opensymphony.xwork.config.providers.XmlConfigurationProvider")) : class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider));
    private Configuration configuration;
    private Set includedFileNames = new TreeSet();
    private String configFileName = "xwork.xml";
    static /* synthetic */ Class class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider;
    static /* synthetic */ Class class$com$opensymphony$xwork$ActionSupport;

    public XmlConfigurationProvider() {
    }

    public XmlConfigurationProvider(String filename) {
        this.configFileName = filename;
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlConfigurationProvider)) {
            return false;
        }
        XmlConfigurationProvider xmlConfigurationProvider = (XmlConfigurationProvider)o;
        return !(this.configFileName != null ? !this.configFileName.equals(xmlConfigurationProvider.configFileName) : xmlConfigurationProvider.configFileName != null);
    }

    public int hashCode() {
        return this.configFileName != null ? this.configFileName.hashCode() : 0;
    }

    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.includedFileNames.clear();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    if ("-//OpenSymphony Group//XWork 1.1.1//EN".equals(publicId)) {
                        return new InputSource(ClassLoaderUtil.getResourceAsStream((String)"xwork-1.1.1.dtd", (Class)(class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider == null ? (class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider = XmlConfigurationProvider.class$("com.opensymphony.xwork.config.providers.XmlConfigurationProvider")) : class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider)));
                    }
                    if ("-//OpenSymphony Group//XWork 1.1//EN".equals(publicId)) {
                        return new InputSource(ClassLoaderUtil.getResourceAsStream((String)"xwork-1.1.dtd", (Class)(class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider == null ? (class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider = XmlConfigurationProvider.class$("com.opensymphony.xwork.config.providers.XmlConfigurationProvider")) : class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider)));
                    }
                    if ("-//OpenSymphony Group//XWork 1.0//EN".equals(publicId)) {
                        return new InputSource(ClassLoaderUtil.getResourceAsStream((String)"xwork-1.0.dtd", (Class)(class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider == null ? (class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider = XmlConfigurationProvider.class$("com.opensymphony.xwork.config.providers.XmlConfigurationProvider")) : class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider)));
                    }
                    return null;
                }
            });
            db.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) {
                }

                public void error(SAXParseException exception) throws SAXException {
                    LOG.error((Object)(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"));
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    LOG.fatal((Object)(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"));
                    throw exception;
                }
            });
            this.loadConfigurationFile(this.configFileName, db);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not load XWork configuration file, failing", (Throwable)e);
            throw new ConfigurationException("Error loading configuration file " + this.configFileName, e);
        }
    }

    public boolean needsReload() {
        boolean needsReload = FileManager.fileNeedsReloading((String)this.configFileName);
        Iterator fileNameIterator = this.includedFileNames.iterator();
        while (!needsReload && fileNameIterator.hasNext()) {
            String fileName = (String)fileNameIterator.next();
            needsReload = FileManager.fileNeedsReloading((String)fileName);
        }
        return needsReload;
    }

    protected InputStream getInputStream(String fileName) {
        return FileManager.loadFile((String)fileName, this.getClass());
    }

    protected void addAction(Element actionElement, PackageConfig packageContext) throws ConfigurationException {
        Map results;
        String name = actionElement.getAttribute("name");
        String className = actionElement.getAttribute("class");
        String methodName = actionElement.getAttribute("method");
        String string = methodName = methodName.trim().length() > 0 ? methodName.trim() : null;
        if (!TextUtils.stringSet((String)className)) {
            className = (class$com$opensymphony$xwork$ActionSupport == null ? (class$com$opensymphony$xwork$ActionSupport = XmlConfigurationProvider.class$("com.opensymphony.xwork.ActionSupport")) : class$com$opensymphony$xwork$ActionSupport).getName();
        }
        if (!this.verifyAction(className, name)) {
            return;
        }
        Map actionParams = XmlHelper.getParams(actionElement);
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), e);
        }
        List interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List externalrefs = this.buildExternalRefs(actionElement, packageContext);
        List exceptionMappings = this.buildExceptionMappings(actionElement, packageContext);
        ActionConfig actionConfig = new ActionConfig(methodName, className, actionParams, results, interceptorList, externalrefs, exceptionMappings, packageContext.getName());
        packageContext.addActionConfig(name, actionConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + (TextUtils.stringSet((String)packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : "") + name + " in '" + packageContext.getName() + "' package:" + actionConfig));
        }
    }

    protected boolean verifyAction(String className, String name) {
        try {
            Class clazz = ObjectFactory.getObjectFactory().getClassInstance(className);
            if (ObjectFactory.getObjectFactory().isNoArgConstructorRequired()) {
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    LOG.error((Object)("Action class [" + className + "] is not public, skipping action [" + name + "]"));
                    return false;
                }
                clazz.getConstructor(new Class[0]);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Action class [" + className + "] not found, skipping action [" + name + "]"), (Throwable)e);
            return false;
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Action class [" + className + "] does not have a public no-arg constructor," + " skipping action [" + name + "]"), (Throwable)e);
            return false;
        }
    }

    protected void addPackage(Element packageElement) throws ConfigurationException {
        PackageConfig newPackage = this.buildPackageContext(packageElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + newPackage));
        }
        this.addResultTypes(newPackage, packageElement);
        this.loadInterceptors(newPackage, packageElement);
        this.loadDefaultInterceptorRef(newPackage, packageElement);
        this.loadGlobalResults(newPackage, packageElement);
        this.loadGobalExceptionMappings(newPackage, packageElement);
        NodeList actionList = packageElement.getElementsByTagName("action");
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element actionElement = (Element)actionList.item(i);
            this.addAction(actionElement, newPackage);
        }
        this.loadDefaultActionRef(newPackage, packageElement);
        this.configuration.addPackageConfig(newPackage.getName(), newPackage);
    }

    protected void addResultTypes(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("result-type");
        for (int i = 0; i < resultTypeList.getLength(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.item(i);
            String name = resultTypeElement.getAttribute("name");
            String className = resultTypeElement.getAttribute("class");
            String def = resultTypeElement.getAttribute("default");
            Class clazz = this.verifyResultType(className);
            if (clazz == null) {
                return;
            }
            ResultTypeConfig resultType = new ResultTypeConfig(name, clazz);
            Map params = XmlHelper.getParams(resultTypeElement);
            if (!params.isEmpty()) {
                resultType.setParams(params);
            }
            packageContext.addResultTypeConfig(resultType);
            if (!"true".equals(def)) continue;
            packageContext.setDefaultResultType(name);
        }
    }

    protected Class verifyResultType(String className) {
        try {
            return ObjectFactory.getObjectFactory().getClassInstance(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Result class [" + className + "] doesn't exist (ClassNotFoundException), ignoring"), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOG.error((Object)("Result class [" + className + "] doesn't exist (NoClassDefFoundError), ignoring"), (Throwable)e);
        }
        return null;
    }

    protected List buildExternalRefs(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList<ExternalReference> refs = new ArrayList<ExternalReference>();
        NodeList externalRefList = element.getElementsByTagName("external-ref");
        String refValue = null;
        for (int i = 0; i < externalRefList.getLength(); ++i) {
            String requiredTemp;
            Element refElement = (Element)externalRefList.item(i);
            if (!refElement.getParentNode().equals(element)) continue;
            String refName = refElement.getAttribute("name");
            if (refElement.getChildNodes().getLength() > 0) {
                refValue = refElement.getChildNodes().item(0).getNodeValue();
            }
            boolean required = (requiredTemp = refElement.getAttribute("required")) == null || "".equals(requiredTemp) ? true : Boolean.valueOf(requiredTemp);
            refs.add(new ExternalReference(refName, refValue, required));
        }
        return refs;
    }

    protected List buildInterceptorList(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList interceptorList = new ArrayList();
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int i = 0; i < interceptorRefList.getLength(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.item(i);
            if (!interceptorRefElement.getParentNode().equals(element)) continue;
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    protected PackageConfig buildPackageContext(Element packageElement) {
        String parent = packageElement.getAttribute("extends");
        String abstractVal = packageElement.getAttribute("abstract");
        boolean isAbstract = Boolean.valueOf(abstractVal);
        String name = TextUtils.noNull((String)packageElement.getAttribute("name"));
        String namespace = TextUtils.noNull((String)packageElement.getAttribute("namespace"));
        ExternalReferenceResolver erResolver = null;
        String externalReferenceResolver = TextUtils.noNull((String)packageElement.getAttribute("externalReferenceResolver"));
        if (!"".equals(externalReferenceResolver)) {
            try {
                erResolver = (ExternalReferenceResolver)ObjectFactory.getObjectFactory().buildBean(externalReferenceResolver, null);
            }
            catch (ClassNotFoundException e) {
                String msg = "Could not find External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                LOG.error((Object)msg);
                throw new ConfigurationException(msg, e);
            }
            catch (Exception e) {
                String msg = "Could not create External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                LOG.error((Object)msg);
                throw new ConfigurationException(msg, e);
            }
        }
        if (!TextUtils.stringSet((String)TextUtils.noNull((String)parent))) {
            return new PackageConfig(name, namespace, isAbstract, erResolver);
        }
        List parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent);
        if (parents.size() <= 0) {
            LOG.error((Object)("Unable to find parent packages " + parent));
            return new PackageConfig(name, namespace, isAbstract, erResolver);
        }
        return new PackageConfig(name, namespace, isAbstract, erResolver, parents);
    }

    protected Map buildResults(Element element, PackageConfig packageContext) {
        NodeList resultEls = element.getElementsByTagName("result");
        TreeMap<String, ResultConfig> results = new TreeMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.getLength(); ++i) {
            TreeMap<String, String> resultParams;
            ResultTypeConfig config;
            Element resultElement = (Element)resultEls.item(i);
            if (!resultElement.getParentNode().equals(element)) continue;
            String resultName = resultElement.getAttribute("name");
            String resultType = resultElement.getAttribute("type");
            if (!TextUtils.stringSet((String)resultName)) {
                resultName = "success";
            }
            if (!TextUtils.stringSet((String)resultType) && !TextUtils.stringSet((String)(resultType = packageContext.getFullDefaultResultType()))) {
                LOG.error((Object)("No result type specified for result named '" + resultName + "', perhaps the parent package does not specify the result type?"));
            }
            if ((config = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(resultType)) == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'");
            }
            Class resultClass = config.getClazz();
            if (resultClass == null) {
                LOG.error((Object)("Result type '" + resultType + "' is invalid. Modify your xwork.xml file."));
            }
            if ((resultParams = XmlHelper.getParams(resultElement)).size() == 0 && resultElement.getChildNodes().getLength() == 1 && resultElement.getChildNodes().item(0).getNodeType() == 3) {
                resultParams = new TreeMap<String, String>();
                try {
                    String paramName = (String)resultClass.getField("DEFAULT_PARAM").get(null);
                    String paramValue = resultElement.getChildNodes().item(0).getNodeValue();
                    if (paramValue != null) {
                        paramValue = paramValue.trim();
                    }
                    resultParams.put(paramName, paramValue);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            TreeMap params = new TreeMap();
            Map configParams = config.getParams();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.putAll(resultParams);
            ResultConfig resultConfig = new ResultConfig(resultName, resultClass, params);
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    protected List buildExceptionMappings(Element element, PackageConfig packageContext) {
        NodeList exceptionMappingEls = element.getElementsByTagName("exception-mapping");
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (int i = 0; i < exceptionMappingEls.getLength(); ++i) {
            Element ehElement = (Element)exceptionMappingEls.item(i);
            if (!ehElement.getParentNode().equals(element)) continue;
            String emName = ehElement.getAttribute("name");
            String exceptionClassName = ehElement.getAttribute("exception");
            String exceptionResult = ehElement.getAttribute("result");
            Map params = XmlHelper.getParams(ehElement);
            if (!TextUtils.stringSet((String)emName)) {
                emName = exceptionResult;
            }
            ExceptionMappingConfig ehConfig = new ExceptionMappingConfig(emName, exceptionClassName, exceptionResult, params);
            exceptionMappings.add(ehConfig);
        }
        return exceptionMappings;
    }

    protected void loadDefaultInterceptorRef(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-interceptor-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.setDefaultInterceptorRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadDefaultActionRef(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-action-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.setDefaultActionRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig packageContext, Element packageElement) {
        NodeList globalResultList = packageElement.getElementsByTagName("global-results");
        if (globalResultList.getLength() > 0) {
            Element globalResultElement = (Element)globalResultList.item(0);
            Map results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected void loadGobalExceptionMappings(PackageConfig packageContext, Element packageElement) {
        NodeList globalExceptionMappingList = packageElement.getElementsByTagName("global-exception-mappings");
        if (globalExceptionMappingList.getLength() > 0) {
            Element globalExceptionMappingElement = (Element)globalExceptionMappingList.item(0);
            List exceptionMappings = this.buildExceptionMappings(globalExceptionMappingElement, packageContext);
            packageContext.addGlobalExceptionMappingConfigs(exceptionMappings);
        }
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig context) throws ConfigurationException {
        String name = element.getAttribute("name");
        InterceptorStackConfig config = new InterceptorStackConfig(name);
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int j = 0; j < interceptorRefList.getLength(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.item(j);
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors(interceptors);
        }
        return config;
    }

    protected void loadInterceptorStacks(Element element, PackageConfig context) throws ConfigurationException {
        NodeList interceptorStackList = element.getElementsByTagName("interceptor-stack");
        for (int i = 0; i < interceptorStackList.getLength(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.item(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void loadInterceptors(PackageConfig context, Element element) throws ConfigurationException {
        NodeList interceptorList = element.getElementsByTagName("interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            String name = interceptorElement.getAttribute("name");
            String className = interceptorElement.getAttribute("class");
            Map params = XmlHelper.getParams(interceptorElement);
            InterceptorConfig config = new InterceptorConfig(name, className, params);
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    private void loadConfigurationFile(String fileName, DocumentBuilder db) {
        if (!this.includedFileNames.contains(fileName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading xwork configuration from: " + fileName));
            }
            this.includedFileNames.add(fileName);
            Document doc = null;
            InputStream is = null;
            try {
                is = this.getInputStream(fileName);
                if (is == null) {
                    throw new Exception("Could not open file " + fileName);
                }
                doc = db.parse(is);
            }
            catch (Exception e) {
                String s = "Caught exception while loading file " + fileName;
                LOG.error((Object)s, (Throwable)e);
                throw new ConfigurationException(s, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unable to close input stream", (Throwable)e);
                    }
                }
            }
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element child = (Element)childNode;
                String nodeName = child.getNodeName();
                if (nodeName.equals("package")) {
                    this.addPackage(child);
                    continue;
                }
                if (!nodeName.equals("include")) continue;
                String includeFileName = child.getAttribute("file");
                this.loadConfigurationFile(includeFileName, db);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loaded xwork configuration from: " + fileName));
            }
        }
    }

    private List lookupInterceptorReference(PackageConfig context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.getAttribute("name");
        Map refParams = XmlHelper.getParams(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference(context, refName, refParams);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

