/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class TextProviderSupport
implements TextProvider {
    private Class clazz;
    private LocaleProvider localeProvider;
    private ResourceBundle bundle;

    public TextProviderSupport(Class clazz, LocaleProvider provider) {
        this.clazz = clazz;
        this.localeProvider = provider;
    }

    public TextProviderSupport(ResourceBundle bundle, LocaleProvider provider) {
        this.bundle = bundle;
        this.localeProvider = provider;
    }

    public String getText(String aTextName) {
        return this.getText(aTextName, aTextName, null);
    }

    public String getText(String aTextName, String defaultValue) {
        return this.getText(aTextName, defaultValue, null);
    }

    public String getText(String aTextName, List args) {
        return this.getText(aTextName, aTextName, args);
    }

    public String getText(String aTextName, String defaultValue, List args) {
        Object[] argsArray;
        Object[] objectArray = argsArray = args != null ? args.toArray() : null;
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, aTextName, this.getLocale(), defaultValue, argsArray);
        }
        return LocalizedTextUtil.findText(this.bundle, aTextName, this.getLocale(), defaultValue, argsArray);
    }

    public String getText(String aTextName, String defaultValue, List args, OgnlValueStack stack) {
        Object[] argsArray = args != null ? args.toArray() : null;
        Locale locale = (Locale)stack.getContext().get("com.opensymphony.xwork.ActionContext.locale");
        if (locale == null) {
            locale = this.getLocale();
        }
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, aTextName, locale, defaultValue, argsArray, stack);
        }
        return LocalizedTextUtil.findText(this.bundle, aTextName, locale, defaultValue, argsArray, stack);
    }

    public ResourceBundle getTexts(String aBundleName) {
        return LocalizedTextUtil.findResourceBundle(aBundleName, this.getLocale());
    }

    public ResourceBundle getTexts() {
        return this.getTexts(this.clazz.getName());
    }

    private Locale getLocale() {
        return this.localeProvider.getLocale();
    }
}

