/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.ObjectUtils;

public class LookupOverride
extends MethodOverride {
    private final String beanName;

    public LookupOverride(String methodName, String beanName) {
        super(methodName);
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean matches(Method method) {
        return method.getName().equals(this.getMethodName()) && method.getParameterTypes().length == 0;
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'; will return bean '" + this.beanName + "'";
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)((LookupOverride)o).beanName);
    }

    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode((Object)this.beanName);
    }
}

