/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader;

import com.opensymphony.webwork.util.classloader.ReloadingClassLoaderListener;
import com.opensymphony.webwork.util.classloader.listeners.ReloadingListener;
import com.opensymphony.webwork.util.classloader.monitor.FilesystemAlterationMonitor;
import com.opensymphony.webwork.util.classloader.readers.FileResourceReader;
import com.opensymphony.webwork.util.classloader.readers.ResourceReader;
import com.opensymphony.webwork.util.classloader.stores.MemoryResourceStore;
import com.opensymphony.webwork.util.classloader.stores.ResourceStore;
import com.opensymphony.webwork.util.classloader.stores.ResourceStoreClassLoader;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog((Class)ReloadingClassLoader.class);
    private final ClassLoader parent;
    private final ResourceStore store;
    private final Collection reloadingListeners = new HashSet();
    private ClassLoader delegate;
    protected final ResourceReader reader;
    protected final File repository;
    protected FilesystemAlterationMonitor fam;
    protected Thread thread;

    public ReloadingClassLoader(ClassLoader pParent, File pRepository) {
        this(pParent, pRepository, new MemoryResourceStore());
    }

    public ReloadingClassLoader(ClassLoader pParent, File pRepository, ResourceStore pStore) {
        super(pParent);
        this.parent = pParent;
        this.repository = pRepository;
        this.reader = new FileResourceReader(this.repository);
        this.store = pStore;
        this.delegate = new ResourceStoreClassLoader(this.parent, this.store);
    }

    public void start() {
        this.fam = new FilesystemAlterationMonitor();
        this.fam.addListener(new ReloadingListener(this.store){

            protected void notifyOfCheck(boolean pReload) {
                super.notifyOfCheck(pReload);
                if (pReload) {
                    ReloadingClassLoader.this.reload();
                } else {
                    ReloadingClassLoader.this.notifyReloadingListeners(false);
                }
            }
        }, this.repository);
        this.thread = new Thread(this.fam);
        this.thread.start();
    }

    public void stop() {
        this.fam.stop();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ReloadingClassLoaderListener pListener) {
        Collection collection = this.reloadingListeners;
        synchronized (collection) {
            this.reloadingListeners.add(pListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(ReloadingClassLoaderListener pListener) {
        Collection collection = this.reloadingListeners;
        synchronized (collection) {
            return this.reloadingListeners.remove(pListener);
        }
    }

    protected void reload() {
        log.debug((Object)"reloading");
        this.delegate = new ResourceStoreClassLoader(this.parent, this.store);
        this.notifyReloadingListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReloadingListeners(boolean pReload) {
        Collection collection = this.reloadingListeners;
        synchronized (collection) {
            Iterator it = this.reloadingListeners.iterator();
            while (it.hasNext()) {
                ReloadingClassLoaderListener listener = (ReloadingClassLoaderListener)it.next();
                listener.hasReloaded(pReload);
            }
        }
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        int p = absFileName.lastIndexOf(46);
        String relFileName = absFileName.substring(rootLength + 1, p);
        String clazzName = relFileName.replace(File.separatorChar, '.');
        return clazzName;
    }

    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }
}

