/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import com.opensymphony.util.GUID;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TokenHelper {
    public static final String DEFAULT_TOKEN_NAME = "webwork.token";
    public static final String TOKEN_NAME_FIELD = "webwork.token.name";
    private static final Log LOG = LogFactory.getLog((Class)TokenHelper.class);

    public static String setToken() {
        return TokenHelper.setToken(DEFAULT_TOKEN_NAME);
    }

    public static String setToken(String tokenName) {
        Map session = ActionContext.getContext().getSession();
        String token = GUID.generateGUID();
        session.put(tokenName, token);
        return token;
    }

    public static String getToken(String tokenName) {
        Map params = ActionContext.getContext().getParameters();
        String[] tokens = (String[])params.get(tokenName);
        if (tokens == null || tokens.length < 1) {
            LOG.warn((Object)("Could not find token mapped to token name " + tokenName));
            return null;
        }
        String token = tokens[0];
        return token;
    }

    public static String getTokenName() {
        Map params = ActionContext.getContext().getParameters();
        if (!params.containsKey(TOKEN_NAME_FIELD)) {
            LOG.warn((Object)"Could not find token name in params.");
            return null;
        }
        String[] tokenNames = (String[])params.get(TOKEN_NAME_FIELD);
        if (tokenNames == null || tokenNames.length < 1) {
            LOG.warn((Object)"Got a null or empty token name.");
            return null;
        }
        String tokenName = tokenNames[0];
        return tokenName;
    }

    public static boolean validToken() {
        String tokenName = TokenHelper.getTokenName();
        if (tokenName == null) {
            return false;
        }
        String token = TokenHelper.getToken(tokenName);
        if (token == null) {
            return false;
        }
        Map session = ActionContext.getContext().getSession();
        String sessionToken = (String)session.get(tokenName);
        if (!token.equals(sessionToken)) {
            LOG.warn((Object)LocalizedTextUtil.findText((Class)TokenHelper.class, (String)"webwork.internal.invalid.token", (Locale)ActionContext.getContext().getLocale(), (String)"Form token {0} does not match the session token {1}.", (Object[])new Object[]{token, sessionToken}));
            return false;
        }
        session.remove(tokenName);
        return true;
    }
}

