/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.quickstart;

import com.opensymphony.webwork.quickstart.Configuration;
import com.opensymphony.webwork.quickstart.Mapping;
import com.opensymphony.webwork.quickstart.MultiDirClassLoader;
import com.opensymphony.webwork.util.classloader.CompilingClassLoader;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuickStart {
    public static void main(String[] args) throws FileNotFoundException, MalformedURLException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String s;
        Configuration c;
        if (args.length != 3 && args.length != 0) {
            System.err.println("QuickStart must be either invoked with three arguments or no arguments:");
            System.err.println("[contextPath] [webapp] [sources]");
            System.err.println("");
            System.err.println("Ex: java -jar webwork.jar \\");
            System.err.println("    quickstart /sandbox sandbox/src/webapp sandbox/src/java");
            System.err.println("");
            System.err.println("OR");
            System.err.println("");
            System.err.println("Ex: java -jar webwork.jar quickstart");
            System.err.println(" Where a 'quickstart.xml' file exists in your working directory");
            return;
        }
        if (args.length == 0) {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.alias("configuration", Configuration.class);
            xstream.alias("extendsConfig", String.class);
            xstream.alias("port", Integer.TYPE);
            xstream.alias("context", String.class);
            xstream.alias("dir", String.class);
            xstream.alias("path", String.class);
            xstream.alias("webDir", Mapping.class);
            File config = new File("quickstart.xml");
            if (!config.exists()) {
                System.err.println("Could not find quickstart.xml!");
                System.err.println("Tip: quickstart.xml must exist in your working directory");
                System.err.println("");
                System.err.println("Alternatively, if you your deployment is simple, try launching");
                System.err.println("QuickStart using the simple command line options rather than");
                System.err.println("Relying on quickstart.xml existing");
                return;
            }
            c = (Configuration)xstream.fromXML((Reader)new FileReader(config));
            c.resolveDirs(config.getParent());
            c.resolveExtensions(config.getParent(), xstream);
        } else {
            c = new Configuration();
            c.setContext(args[0]);
            c.setPort(new Integer(8080));
            ArrayList<Mapping> webDirs = new ArrayList<Mapping>();
            webDirs.add(new Mapping("/", args[1]));
            c.setWebDirs(webDirs);
            ArrayList<String> sources = new ArrayList<String>();
            sources.add(args[2]);
            c.setSources(sources);
            ArrayList<String> classDirs = new ArrayList<String>();
            classDirs.add(args[1] + "/WEB-INF/classes");
            c.setClassDirs(classDirs);
            ArrayList<String> libs = new ArrayList<String>();
            libs.add("lib");
            c.setLibs(libs);
            c.resolveDirs(new File(".").getParent());
        }
        if (c.validate()) {
            return;
        }
        System.out.println("Launching Jetty with the following configuration:");
        System.out.println("Jars/Directory of jars:");
        Iterator<Object> iterator = c.getLibs().iterator();
        while (iterator.hasNext()) {
            s = (String)iterator.next();
            System.out.println("    " + s);
        }
        System.out.println("Directories of classes:");
        iterator = c.getClassDirs().iterator();
        while (iterator.hasNext()) {
            s = (String)iterator.next();
            System.out.println("    " + s);
        }
        if (c.getSources() != null) {
            System.out.println("Sources:");
            iterator = c.getSources().iterator();
            while (iterator.hasNext()) {
                s = (String)iterator.next();
                System.out.println("    " + s);
            }
        }
        System.out.println("WebApp directories:");
        iterator = c.getMappings().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            System.out.println(entry.getKey() + "  ->  " + entry.getValue());
        }
        List libs = c.getLibs();
        List classDirs = c.getClassDirs();
        ClassLoader parent = new MultiDirClassLoader(libs.toArray(new String[libs.size()]), classDirs.toArray(new String[classDirs.size()]), Thread.currentThread().getContextClassLoader());
        if (c.getSources() != null) {
            Iterator iterator2 = c.getSources().iterator();
            while (iterator2.hasNext()) {
                String source = (String)iterator2.next();
                File file = new File(source);
                CompilingClassLoader ccl = new CompilingClassLoader(parent, file);
                ccl.start();
                parent = ccl;
            }
        }
        MyURLClassLoader url = new MyURLClassLoader(parent);
        Thread.currentThread().setContextClassLoader(url);
        Class<?> clazz = url.loadClass("com.opensymphony.webwork.quickstart.JettyServer");
        Method method = clazz.getDeclaredMethod("startServer", Integer.TYPE, String.class, List.class, Map.class, String.class);
        method.invoke(null, c.port, c.getContext(), c.getPathPriority(), c.getMappings(), c.getResolver());
        System.out.println("");
        System.out.println("********************************************************");
        System.out.println("Quick-started at http://localhost:" + c.getPort() + c.getContext());
        System.out.println("You may now edit your Java source files and web files.");
        System.out.println("********************************************************");
    }

    static class MyURLClassLoader
    extends URLClassLoader {
        private ClassLoader parent;

        public MyURLClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
            this.parent = parent;
        }

        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("java.") || name.startsWith("sun.") || name.startsWith("com.sun.")) {
                return super.loadClass(name, resolve);
            }
            ClassLoader parent = this.getParent();
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (Throwable t) {
                    c = parent.loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        public URL getResource(String name) {
            URL url = this.findResource(name);
            if (url == null && this.parent != null) {
                url = this.parent.getResource(name);
            }
            return url;
        }
    }
}

