/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.util.TokenHelper;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TokenInterceptor
implements Interceptor {
    public static final String INVALID_TOKEN_CODE = "invalid.token";
    private static final Log LOG = LogFactory.getLog((Class)TokenInterceptor.class);

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        Map session;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Intercepting invocation to check for valid transaction token.");
        }
        Map map = session = ActionContext.getContext().getSession();
        synchronized (map) {
            if (!TokenHelper.validToken()) {
                return this.handleInvalidToken(invocation);
            }
            return this.handleValidToken(invocation);
        }
    }

    protected String handleInvalidToken(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        String errorMessage = LocalizedTextUtil.findText(this.getClass(), (String)"webwork.messages.invalid.token", (Locale)invocation.getInvocationContext().getLocale(), (String)"The form has already been processed or no token was supplied, please try again.", (Object[])new Object[0]);
        if (action instanceof ValidationAware) {
            ((ValidationAware)action).addActionError(errorMessage);
        } else {
            LOG.warn((Object)errorMessage);
        }
        return INVALID_TOKEN_CODE;
    }

    protected String handleValidToken(ActionInvocation invocation) throws Exception {
        return invocation.invoke();
    }
}

