/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.portlet.context.PortletActionContext;
import com.opensymphony.webwork.portlet.util.PortletUrlHelper;
import com.opensymphony.webwork.views.util.UrlHelper;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URL
extends Component {
    private static final Log LOG = LogFactory.getLog((Class)URL.class);
    public static final String NONE = "none";
    public static final String GET = "get";
    public static final String ALL = "all";
    private HttpServletRequest req;
    private HttpServletResponse res;
    protected String includeParams;
    protected String scheme;
    protected String value;
    protected String action;
    protected String namespace;
    protected String method;
    protected boolean encode = true;
    protected boolean includeContext = true;
    protected String portletMode;
    protected String windowState;
    protected String portletUrlType;

    public URL(OgnlValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack);
        this.req = req;
        this.res = res;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        if (this.value != null) {
            this.value = this.findString(this.value);
        }
        try {
            String includeParams = null;
            if (this.includeParams != null) {
                includeParams = this.findString(this.includeParams);
            }
            if (includeParams == null && this.value == null || GET.equalsIgnoreCase(includeParams)) {
                String query = this.req.getQueryString();
                if (query != null) {
                    int idx = query.lastIndexOf(35);
                    if (idx != -1) {
                        query = query.substring(0, idx - 1);
                    }
                    this.mergeRequestParameters(this.parameters, HttpUtils.parseQueryString((String)query));
                }
            } else if (ALL.equalsIgnoreCase(includeParams)) {
                this.mergeRequestParameters(this.parameters, this.req.getParameterMap());
            } else if (this.value == null && !NONE.equalsIgnoreCase(includeParams)) {
                LOG.warn((Object)("Unknown value for includeParams parameter to URL tag: " + includeParams));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to put request parameters (" + this.req.getQueryString() + ") into parameter map."), (Throwable)e);
        }
        return result;
    }

    public boolean end(Writer writer, String body) {
        String scheme = this.req.getScheme();
        if (this.scheme != null) {
            scheme = this.scheme;
        }
        String result = this.value == null && this.action != null ? (PortletActionContext.isPortletRequest() ? PortletUrlHelper.buildUrl(this.action, this.namespace, this.parameters, this.portletUrlType, this.portletMode, this.windowState) : this.determineActionURL(this.action, this.namespace, this.method, this.req, this.res, this.parameters, scheme, this.includeContext, this.encode)) : (PortletActionContext.isPortletRequest() ? PortletUrlHelper.buildResourceUrl(this.value, this.parameters) : UrlHelper.buildUrl(this.value, this.req, this.res, this.parameters, scheme, this.includeContext, this.encode));
        String id = this.getId();
        if (id != null) {
            this.getStack().getContext().put(id, result);
            this.req.setAttribute(id, (Object)result);
        } else {
            try {
                writer.write(result);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("IOError: " + e.getMessage(), e);
            }
        }
        return super.end(writer, body);
    }

    public void setIncludeParams(String includeParams) {
        this.includeParams = includeParams;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    public void setIncludeContext(boolean includeContext) {
        this.includeContext = includeContext;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    public void setPortletUrlType(String portletUrlType) {
        this.portletUrlType = portletUrlType;
    }

    protected void mergeRequestParameters(Map parameters, Map contextParameters) {
        Iterator iterator = contextParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            if (parameters.containsKey(key)) continue;
            parameters.put(key, entry.getValue());
        }
    }
}

