/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;

class SshAgentDeleteKey
extends SubsystemMessage {
    public static final int SSH_AGENT_DELETE_KEY = 207;
    SshPublicKey pubkey;
    String description;

    public SshAgentDeleteKey() {
        super(207);
    }

    public SshAgentDeleteKey(SshPublicKey sshPublicKey, String string) {
        super(207);
        this.pubkey = sshPublicKey;
        this.description = string;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMessageName() {
        return "SSH_AGENT_DELETE_KEY";
    }

    public void constructByteArray(ByteArrayWriter byteArrayWriter) throws IOException, InvalidMessageException {
        try {
            byteArrayWriter.writeBinaryString(this.pubkey.getEncoded());
            byteArrayWriter.writeString(this.description);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }

    public void constructMessage(ByteArrayReader byteArrayReader) throws IOException, InvalidMessageException {
        try {
            this.pubkey = SshKeyPairFactory.decodePublicKey(byteArrayReader.readBinaryString());
            this.description = byteArrayReader.readString();
        }
        catch (IOException iOException) {
            throw new InvalidMessageException(iOException.getMessage());
        }
    }
}

