/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.attributehandlers.AttributeHandler;
import org.jfree.xml.util.AbstractModelReader;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.MultiplexMappingEntry;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.PropertyDefinition;

public class ObjectFactoryLoader
extends AbstractModelReader
implements ObjectFactory {
    private HashMap objectMappings = new HashMap();
    private HashMap manualMappings = new HashMap();
    private HashMap multiplexMappings = new HashMap();
    private Class target;
    private String registerName;
    private ArrayList propertyDefinition;
    private ArrayList attributeDefinition;
    private ArrayList constructorDefinition;
    private ArrayList lookupDefinitions;
    private ArrayList orderedNames;
    private String baseClass;
    private String attributeName;
    private ArrayList multiplexEntries;

    public ObjectFactoryLoader(URL uRL) throws ObjectDescriptionException {
        this.parseXml(uRL);
        this.rebuildSuperClasses();
    }

    private void rebuildSuperClasses() throws ObjectDescriptionException {
        this.propertyDefinition = new ArrayList();
        this.attributeDefinition = new ArrayList();
        this.constructorDefinition = new ArrayList();
        this.lookupDefinitions = new ArrayList();
        this.orderedNames = new ArrayList();
        HashMap hashMap = new HashMap();
        for (Object k : this.objectMappings.keySet()) {
            GenericObjectFactory genericObjectFactory = (GenericObjectFactory)this.objectMappings.get(k);
            this.performSuperClassUpdate(genericObjectFactory);
            PropertyDefinition[] propertyDefinitionArray = this.propertyDefinition.toArray(new PropertyDefinition[0]);
            LookupDefinition[] lookupDefinitionArray = this.lookupDefinitions.toArray(new LookupDefinition[0]);
            AttributeDefinition[] attributeDefinitionArray = this.attributeDefinition.toArray(new AttributeDefinition[0]);
            ConstructorDefinition[] constructorDefinitionArray = this.constructorDefinition.toArray(new ConstructorDefinition[0]);
            String[] stringArray = this.orderedNames.toArray(new String[0]);
            GenericObjectFactory genericObjectFactory2 = new GenericObjectFactory(genericObjectFactory.getBaseClass(), genericObjectFactory.getRegisterName(), constructorDefinitionArray, propertyDefinitionArray, lookupDefinitionArray, attributeDefinitionArray, stringArray);
            hashMap.put(k, genericObjectFactory2);
            this.propertyDefinition.clear();
            this.attributeDefinition.clear();
            this.constructorDefinition.clear();
            this.lookupDefinitions.clear();
            this.orderedNames.clear();
        }
        this.objectMappings.clear();
        this.objectMappings = hashMap;
        this.propertyDefinition = null;
        this.attributeDefinition = null;
        this.constructorDefinition = null;
        this.lookupDefinitions = null;
        this.orderedNames = null;
    }

    private void performSuperClassUpdate(GenericObjectFactory genericObjectFactory) {
        GenericObjectFactory genericObjectFactory2;
        Class clazz = genericObjectFactory.getBaseClass().getSuperclass();
        if (clazz != null && !clazz.equals(Object.class) && (genericObjectFactory2 = (GenericObjectFactory)this.objectMappings.get(clazz)) != null) {
            this.performSuperClassUpdate(genericObjectFactory2);
        }
        this.propertyDefinition.addAll(Arrays.asList(genericObjectFactory.getPropertyDefinitions()));
        this.attributeDefinition.addAll(Arrays.asList(genericObjectFactory.getAttributeDefinitions()));
        this.constructorDefinition.addAll(Arrays.asList(genericObjectFactory.getConstructorDefinitions()));
        this.lookupDefinitions.addAll(Arrays.asList(genericObjectFactory.getLookupDefinitions()));
        this.orderedNames.addAll(Arrays.asList(genericObjectFactory.getOrderedPropertyNames()));
    }

    protected boolean startObjectDefinition(String string, String string2, boolean bl) throws ObjectDescriptionException {
        if (bl) {
            return false;
        }
        this.target = this.loadClass(string);
        if (this.target == null) {
            Log.warn(new Log.SimpleMessage("Failed to load class ", string));
            return false;
        }
        this.registerName = string2;
        this.propertyDefinition = new ArrayList();
        this.attributeDefinition = new ArrayList();
        this.constructorDefinition = new ArrayList();
        this.lookupDefinitions = new ArrayList();
        this.orderedNames = new ArrayList();
        return true;
    }

    protected void handleAttributeDefinition(String string, String string2, String string3) throws ObjectDescriptionException {
        AttributeHandler attributeHandler = this.loadAttributeHandler(string3);
        this.orderedNames.add(string);
        this.attributeDefinition.add(new AttributeDefinition(string, string2, attributeHandler));
    }

    protected void handleElementDefinition(String string, String string2) throws ObjectDescriptionException {
        this.orderedNames.add(string);
        this.propertyDefinition.add(new PropertyDefinition(string, string2));
    }

    protected void handleLookupDefinition(String string, String string2) throws ObjectDescriptionException {
        LookupDefinition lookupDefinition = new LookupDefinition(string, string2);
        this.orderedNames.add(string);
        this.lookupDefinitions.add(lookupDefinition);
    }

    protected void endObjectDefinition() throws ObjectDescriptionException {
        PropertyDefinition[] propertyDefinitionArray = this.propertyDefinition.toArray(new PropertyDefinition[0]);
        LookupDefinition[] lookupDefinitionArray = this.lookupDefinitions.toArray(new LookupDefinition[0]);
        AttributeDefinition[] attributeDefinitionArray = this.attributeDefinition.toArray(new AttributeDefinition[0]);
        ConstructorDefinition[] constructorDefinitionArray = this.constructorDefinition.toArray(new ConstructorDefinition[0]);
        String[] stringArray = this.orderedNames.toArray(new String[0]);
        GenericObjectFactory genericObjectFactory = new GenericObjectFactory(this.target, this.registerName, constructorDefinitionArray, propertyDefinitionArray, lookupDefinitionArray, attributeDefinitionArray, stringArray);
        this.objectMappings.put(this.target, genericObjectFactory);
    }

    protected void handleConstructorDefinition(String string, String string2) {
        Class clazz = this.loadClass(string2);
        this.orderedNames.add(string);
        this.constructorDefinition.add(new ConstructorDefinition(string, clazz));
    }

    protected boolean handleManualMapping(String string, String string2, String string3) throws ObjectDescriptionException {
        if (!this.manualMappings.containsKey(string)) {
            Class clazz = this.loadClass(string);
            this.manualMappings.put(clazz, new ManualMappingDefinition(clazz, string2, string3));
            return true;
        }
        return false;
    }

    protected void startMultiplexMapping(String string, String string2) {
        this.baseClass = string;
        this.attributeName = string2;
        this.multiplexEntries = new ArrayList();
    }

    protected void handleMultiplexMapping(String string, String string2) throws ObjectDescriptionException {
        this.multiplexEntries.add(new MultiplexMappingEntry(string, string2));
    }

    protected void endMultiplexMapping() throws ObjectDescriptionException {
        MultiplexMappingEntry[] multiplexMappingEntryArray = this.multiplexEntries.toArray(new MultiplexMappingEntry[0]);
        Class clazz = this.loadClass(this.baseClass);
        this.multiplexMappings.put(clazz, new MultiplexMappingDefinition(clazz, this.attributeName, multiplexMappingEntryArray));
        this.multiplexEntries = null;
    }

    private AttributeHandler loadAttributeHandler(String string) throws ObjectDescriptionException {
        Class clazz = this.loadClass(string);
        try {
            return (AttributeHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ObjectDescriptionException("Invalid attribute handler specified: " + string);
        }
    }

    public boolean isGenericHandler(Class clazz) {
        return this.objectMappings.containsKey(clazz);
    }

    public GenericObjectFactory getFactoryForClass(Class clazz) {
        GenericObjectFactory genericObjectFactory = (GenericObjectFactory)this.objectMappings.get(clazz);
        if (genericObjectFactory == null) {
            return null;
        }
        return genericObjectFactory.getInstance();
    }

    public ManualMappingDefinition getManualMappingDefinition(Class clazz) {
        return (ManualMappingDefinition)this.manualMappings.get(clazz);
    }

    public MultiplexMappingDefinition getMultiplexDefinition(Class clazz) {
        MultiplexMappingDefinition multiplexMappingDefinition = (MultiplexMappingDefinition)this.multiplexMappings.get(clazz);
        return multiplexMappingDefinition;
    }
}

