/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.CommentHandler;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.util.BasicTypeSupport;
import org.jfree.xml.util.ObjectDescriptionException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModelReader {
    private static final int STATE_START = 0;
    private static final int IN_OBJECT = 1;
    private static final int IGNORE_OBJECT = 2;
    private static final int MAPPING_STATE = 3;
    private static final int CONSTRUCTOR_STATE = 4;
    private CommentHandler commentHandler = new CommentHandler();
    private String[] closeComment;
    private String[] openComment;

    protected CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    protected String[] getCloseComment() {
        return this.closeComment;
    }

    protected String[] getOpenComment() {
        return this.openComment;
    }

    protected void setCloseComment(String[] stringArray) {
        this.closeComment = stringArray;
    }

    protected void setOpenComment(String[] stringArray) {
        this.openComment = stringArray;
    }

    protected void parseXml(URL uRL) throws ObjectDescriptionException {
        this.parseXmlDocument(uRL, false);
    }

    protected void parseXmlDocument(URL uRL, boolean bl) throws ObjectDescriptionException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            SAXModelHandler sAXModelHandler = new SAXModelHandler(uRL, bl);
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.getCommentHandler());
            }
            catch (SAXException sAXException) {
                Log.debug("Comments are not supported by this SAX implementation.");
            }
            xMLReader.setContentHandler(sAXModelHandler);
            xMLReader.setDTDHandler(sAXModelHandler);
            xMLReader.setErrorHandler(sAXModelHandler);
            xMLReader.parse(new InputSource(bufferedInputStream));
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            Log.warn("Unable to load factory specifications", exception);
            throw new ObjectDescriptionException("Unable to load object factory specs.", exception);
        }
    }

    protected void startRootDocument() {
    }

    protected void endRootDocument() {
    }

    protected void startIncludeHandling(URL uRL) {
    }

    protected void endIncludeHandling() {
    }

    protected void handleIgnoredProperty(String string) {
    }

    protected abstract boolean handleManualMapping(String var1, String var2, String var3) throws ObjectDescriptionException;

    protected abstract boolean startObjectDefinition(String var1, String var2, boolean var3) throws ObjectDescriptionException;

    protected abstract void handleAttributeDefinition(String var1, String var2, String var3) throws ObjectDescriptionException;

    protected abstract void handleElementDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void handleLookupDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void endObjectDefinition() throws ObjectDescriptionException;

    protected abstract void startMultiplexMapping(String var1, String var2);

    protected abstract void handleMultiplexMapping(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void endMultiplexMapping() throws ObjectDescriptionException;

    protected abstract void handleConstructorDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected Class loadClass(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("::")) {
            return BasicTypeSupport.getClassRepresentation(string);
        }
        try {
            return ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
        }
        catch (Exception exception) {
            Log.warn("Unable to load class", exception);
            return null;
        }
    }

    private class SAXModelHandler
    extends DefaultHandler {
        private URL resource;
        private int state;
        private Stack openComments;
        private boolean isInclude;

        public SAXModelHandler(URL uRL, boolean bl) {
            if (uRL == null) {
                throw new NullPointerException();
            }
            this.resource = uRL;
            this.openComments = new Stack();
            this.isInclude = bl;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            AbstractModelReader.this.setOpenComment(AbstractModelReader.this.getCommentHandler().getComments());
            this.openComments.push(AbstractModelReader.this.getOpenComment());
            AbstractModelReader.this.setCloseComment(null);
            try {
                if (!this.isInclude && string3.equals("objects")) {
                    AbstractModelReader.this.startRootDocument();
                    return;
                }
                if (this.getState() == 0) {
                    this.startRootElement(string3, attributes);
                } else {
                    if (this.getState() == 2) {
                        return;
                    }
                    if (this.getState() == 1) {
                        this.startObjectElement(string3, attributes);
                    } else if (this.getState() == 3) {
                        if (!string3.equals("type")) {
                            throw new SAXException("Expected 'type' tag");
                        }
                        String string4 = attributes.getValue("name");
                        String string5 = attributes.getValue("class");
                        AbstractModelReader.this.handleMultiplexMapping(string4, string5);
                    } else if (this.getState() == 4) {
                        if (!string3.equals("parameter")) {
                            throw new SAXException("Expected 'parameter' tag");
                        }
                        String string6 = attributes.getValue("class");
                        String string7 = attributes.getValue("property");
                        AbstractModelReader.this.handleConstructorDefinition(string7, string6);
                    }
                }
            }
            catch (ObjectDescriptionException objectDescriptionException) {
                throw new SAXException(objectDescriptionException);
            }
            finally {
                AbstractModelReader.this.getCommentHandler().clearComments();
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            AbstractModelReader.this.setOpenComment((String[])this.openComments.pop());
            AbstractModelReader.this.setCloseComment(AbstractModelReader.this.getCommentHandler().getComments());
            try {
                if (!this.isInclude && string3.equals("objects")) {
                    AbstractModelReader.this.endRootDocument();
                    return;
                }
                if (string3.equals("object")) {
                    if (this.getState() != 2) {
                        AbstractModelReader.this.endObjectDefinition();
                    }
                    this.setState(0);
                } else if (string3.equals("mapping")) {
                    this.setState(0);
                    AbstractModelReader.this.endMultiplexMapping();
                } else if (string3.equals("constructor") && this.getState() != 2) {
                    this.setState(1);
                }
            }
            catch (ObjectDescriptionException objectDescriptionException) {
                throw new SAXException(objectDescriptionException);
            }
            finally {
                AbstractModelReader.this.getCommentHandler().clearComments();
            }
        }

        private void startObjectElement(String string, Attributes attributes) throws ObjectDescriptionException {
            if (string.equals("constructor")) {
                this.setState(4);
            } else if (string.equals("lookup")) {
                String string2 = attributes.getValue("name");
                String string3 = attributes.getValue("lookup");
                AbstractModelReader.this.handleLookupDefinition(string2, string3);
            } else if (string.equals("ignore")) {
                String string4 = attributes.getValue("name");
                AbstractModelReader.this.handleIgnoredProperty(string4);
            } else if (string.equals("element-property")) {
                String string5 = attributes.getValue("element");
                String string6 = attributes.getValue("name");
                AbstractModelReader.this.handleElementDefinition(string6, string5);
            } else if (string.equals("attribute-property")) {
                String string7 = attributes.getValue("name");
                String string8 = attributes.getValue("attribute");
                String string9 = attributes.getValue("handler");
                AbstractModelReader.this.handleAttributeDefinition(string7, string8, string9);
            }
        }

        private void startRootElement(String string, Attributes attributes) throws SAXException, ObjectDescriptionException {
            if (string.equals("include")) {
                if (this.isInclude) {
                    Log.warn("Ignored nested include tag.");
                    return;
                }
                String string2 = attributes.getValue("src");
                try {
                    URL uRL = new URL(this.resource, string2);
                    AbstractModelReader.this.startIncludeHandling(uRL);
                    AbstractModelReader.this.parseXmlDocument(uRL, true);
                    AbstractModelReader.this.endIncludeHandling();
                }
                catch (Exception exception) {
                    throw new ElementDefinitionException(exception, "Unable to include file from " + string2);
                }
            } else if (string.equals("object")) {
                boolean bl;
                this.setState(1);
                String string3 = attributes.getValue("class");
                String string4 = attributes.getValue("register-name");
                if (string4 != null && string4.length() == 0) {
                    string4 = null;
                }
                if (!AbstractModelReader.this.startObjectDefinition(string3, string4, bl = "true".equals(attributes.getValue("ignore")))) {
                    this.setState(2);
                }
            } else if (string.equals("manual")) {
                String string5 = attributes.getValue("class");
                String string6 = attributes.getValue("read-handler");
                String string7 = attributes.getValue("write-handler");
                AbstractModelReader.this.handleManualMapping(string5, string6, string7);
            } else if (string.equals("mapping")) {
                this.setState(3);
                String string8 = attributes.getValue("type-attribute");
                String string9 = attributes.getValue("base-class");
                AbstractModelReader.this.startMultiplexMapping(string9, string8);
            }
        }

        private int getState() {
            return this.state;
        }

        private void setState(int n) {
            this.state = n;
        }
    }
}

