/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser.coretypes;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.jfree.xml.parser.AbstractXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListReadHandler
extends AbstractXmlReadHandler {
    private List retval;
    private ArrayList handlers;
    private String listType;

    protected void startParsing(Attributes attributes) throws SAXException {
        this.listType = attributes.getValue("type");
        if (this.listType == null) {
            this.listType = "array-list";
        }
        this.handlers = new ArrayList();
    }

    protected XmlReadHandler getHandlerForChild(String string, Attributes attributes) throws XmlReaderException, SAXException {
        XmlReadHandler xmlReadHandler = this.getRootHandler().createHandler(Object.class, string, attributes);
        this.handlers.add(xmlReadHandler);
        return xmlReadHandler;
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        XmlReadHandler[] xmlReadHandlerArray = this.handlers.toArray(new XmlReadHandler[this.handlers.size()]);
        this.retval = this.createList(xmlReadHandlerArray.length);
        for (int i = 0; i < xmlReadHandlerArray.length; ++i) {
            this.retval.add(xmlReadHandlerArray[i].getObject());
        }
        this.handlers.clear();
    }

    private List createList(int n) {
        if (this.listType.equals("stack")) {
            return new Stack();
        }
        if (this.listType.equals("linked-list")) {
            return new LinkedList();
        }
        if (this.listType.equals("vector")) {
            return new Vector(n);
        }
        return new ArrayList(n);
    }

    public Object getObject() {
        return this.retval;
    }
}

