/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.FrontendDefaultHandler;
import org.jfree.xml.ParseException;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.parser.coretypes.BasicStrokeReadHandler;
import org.jfree.xml.parser.coretypes.ColorReadHandler;
import org.jfree.xml.parser.coretypes.FontReadHandler;
import org.jfree.xml.parser.coretypes.GenericReadHandler;
import org.jfree.xml.parser.coretypes.GradientPaintReadHandler;
import org.jfree.xml.parser.coretypes.InsetsReadHandler;
import org.jfree.xml.parser.coretypes.ListReadHandler;
import org.jfree.xml.parser.coretypes.Point2DReadHandler;
import org.jfree.xml.parser.coretypes.Rectangle2DReadHandler;
import org.jfree.xml.parser.coretypes.RenderingHintsReadHandler;
import org.jfree.xml.parser.coretypes.StringReadHandler;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.MultiplexMappingEntry;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.SimpleObjectFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class RootXmlReadHandler
extends FrontendDefaultHandler {
    private Stack currentHandlers;
    private Stack outerScopes;
    private XmlReadHandler rootHandler;
    private HashMap objectRegistry = new HashMap();
    private SimpleObjectFactory classToHandlerMapping = new SimpleObjectFactory();
    private boolean rootHandlerInitialized;

    protected void addDefaultMappings() {
        MultiplexMappingEntry[] multiplexMappingEntryArray = new MultiplexMappingEntry[]{new MultiplexMappingEntry("color", Color.class.getName()), new MultiplexMappingEntry("gradientPaint", GradientPaint.class.getName())};
        this.addMultiplexMapping(Paint.class, "type", multiplexMappingEntryArray);
        this.addManualMapping(Color.class, ColorReadHandler.class);
        this.addManualMapping(GradientPaint.class, GradientPaintReadHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray2 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Point2D.Float.class.getName()), new MultiplexMappingEntry("double", Point2D.Double.class.getName())};
        this.addMultiplexMapping(Point2D.class, "type", multiplexMappingEntryArray2);
        this.addManualMapping(Point2D.Float.class, Point2DReadHandler.class);
        this.addManualMapping(Point2D.Double.class, Point2DReadHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray3 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Rectangle2D.Float.class.getName()), new MultiplexMappingEntry("double", Rectangle2D.Double.class.getName())};
        this.addMultiplexMapping(Rectangle2D.class, "type", multiplexMappingEntryArray3);
        this.addManualMapping(Rectangle2D.Float.class, Rectangle2DReadHandler.class);
        this.addManualMapping(Rectangle2D.Double.class, Rectangle2DReadHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray4 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("array-list", ArrayList.class.getName()), new MultiplexMappingEntry("linked-list", LinkedList.class.getName()), new MultiplexMappingEntry("vector", Vector.class.getName()), new MultiplexMappingEntry("stack", Stack.class.getName())};
        this.addMultiplexMapping(List.class, "type", multiplexMappingEntryArray4);
        this.addManualMapping(LinkedList.class, ListReadHandler.class);
        this.addManualMapping(Vector.class, ListReadHandler.class);
        this.addManualMapping(ArrayList.class, ListReadHandler.class);
        this.addManualMapping(Stack.class, ListReadHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray5 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("basic", BasicStroke.class.getName())};
        this.addMultiplexMapping(Stroke.class, "type", multiplexMappingEntryArray5);
        this.addManualMapping(BasicStroke.class, BasicStrokeReadHandler.class);
        this.addManualMapping(Font.class, FontReadHandler.class);
        this.addManualMapping(Insets.class, InsetsReadHandler.class);
        this.addManualMapping(RenderingHints.class, RenderingHintsReadHandler.class);
        this.addManualMapping(String.class, StringReadHandler.class);
    }

    public abstract ObjectFactory getFactoryLoader();

    protected void addManualMapping(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            throw new NullPointerException("handler must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("classToRead must not be null.");
        }
        if (!XmlReadHandler.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("The given handler is no XmlReadHandler.");
        }
        this.classToHandlerMapping.addManualMapping(new ManualMappingDefinition(clazz, clazz2.getName(), null));
    }

    protected void addMultiplexMapping(Class clazz, String string, MultiplexMappingEntry[] multiplexMappingEntryArray) {
        this.classToHandlerMapping.addMultiplexMapping(new MultiplexMappingDefinition(clazz, string, multiplexMappingEntryArray));
    }

    public void setHelperObject(String string, Object object) {
        if (object == null) {
            this.objectRegistry.remove(string);
        } else {
            this.objectRegistry.put(string, object);
        }
    }

    public Object getHelperObject(String string) {
        return this.objectRegistry.get(string);
    }

    public XmlReadHandler createHandler(Class clazz, String string, Attributes attributes) throws XmlReaderException {
        XmlReadHandler xmlReadHandler = this.findHandlerForClass(clazz, attributes, new ArrayList());
        if (xmlReadHandler == null) {
            throw new NullPointerException("Unable to find handler for class: " + clazz);
        }
        xmlReadHandler.init(this, string);
        return xmlReadHandler;
    }

    private XmlReadHandler findHandlerForClass(Class clazz, Attributes attributes, ArrayList arrayList) throws XmlReaderException {
        ObjectFactory objectFactory = this.getFactoryLoader();
        if (arrayList.contains(clazz)) {
            throw new IllegalStateException("Circular reference detected: " + arrayList);
        }
        arrayList.add(clazz);
        ManualMappingDefinition manualMappingDefinition = this.classToHandlerMapping.getManualMappingDefinition(clazz);
        if (manualMappingDefinition == null) {
            manualMappingDefinition = objectFactory.getManualMappingDefinition(clazz);
        }
        if (manualMappingDefinition != null) {
            return this.loadHandlerClass(manualMappingDefinition.getReadHandler());
        }
        MultiplexMappingDefinition multiplexMappingDefinition = this.getFactoryLoader().getMultiplexDefinition(clazz);
        if (multiplexMappingDefinition == null) {
            multiplexMappingDefinition = this.classToHandlerMapping.getMultiplexDefinition(clazz);
        }
        if (multiplexMappingDefinition != null) {
            String string = attributes.getValue(multiplexMappingDefinition.getAttributeName());
            if (string == null) {
                throw new XmlReaderException("Multiplexer type attribute is not defined: " + multiplexMappingDefinition.getAttributeName() + " for " + clazz);
            }
            MultiplexMappingEntry multiplexMappingEntry = multiplexMappingDefinition.getEntryForType(string);
            if (multiplexMappingEntry == null) {
                throw new XmlReaderException("Invalid type attribute value: " + multiplexMappingDefinition.getAttributeName() + " = " + string);
            }
            Class clazz2 = this.loadClass(multiplexMappingEntry.getTargetClass());
            if (!clazz2.equals(multiplexMappingDefinition.getBaseClass())) {
                return this.findHandlerForClass(clazz2, attributes, arrayList);
            }
        }
        if (this.classToHandlerMapping.isGenericHandler(clazz)) {
            return new GenericReadHandler(this.classToHandlerMapping.getFactoryForClass(clazz));
        }
        if (this.getFactoryLoader().isGenericHandler(clazz)) {
            return new GenericReadHandler(this.getFactoryLoader().getFactoryForClass(clazz));
        }
        return null;
    }

    protected void setRootHandler(XmlReadHandler xmlReadHandler) {
        this.rootHandler = xmlReadHandler;
        this.rootHandlerInitialized = false;
    }

    protected XmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public void recurse(XmlReadHandler xmlReadHandler, String string, Attributes attributes) throws XmlReaderException, SAXException {
        this.outerScopes.push(this.currentHandlers);
        this.currentHandlers = new Stack();
        this.currentHandlers.push(xmlReadHandler);
        xmlReadHandler.startElement(string, attributes);
    }

    public void delegate(XmlReadHandler xmlReadHandler, String string, Attributes attributes) throws XmlReaderException, SAXException {
        this.currentHandlers.push(xmlReadHandler);
        xmlReadHandler.init(this, string);
        xmlReadHandler.startElement(string, attributes);
    }

    public void unwind(String string) throws SAXException, XmlReaderException {
        this.currentHandlers.pop();
        if (this.currentHandlers.isEmpty() && !this.outerScopes.isEmpty()) {
            this.currentHandlers = (Stack)this.outerScopes.pop();
        } else if (!this.currentHandlers.isEmpty()) {
            this.getCurrentHandler().endElement(string);
        }
    }

    protected XmlReadHandler getCurrentHandler() {
        return (XmlReadHandler)this.currentHandlers.peek();
    }

    public void startDocument() throws SAXException {
        this.outerScopes = new Stack();
        this.currentHandlers = new Stack();
        this.currentHandlers.push(this.rootHandler);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.rootHandlerInitialized) {
            this.rootHandler.init(this, string3);
            this.rootHandlerInitialized = true;
        }
        try {
            this.getCurrentHandler().startElement(string3, attributes);
        }
        catch (XmlReaderException xmlReaderException) {
            throw new ParseException(xmlReaderException, this.getLocator());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.getCurrentHandler().characters(cArray, n, n2);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new ParseException(exception, this.getLocator());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.getCurrentHandler().endElement(string3);
        }
        catch (XmlReaderException xmlReaderException) {
            throw new ParseException(xmlReaderException, this.getLocator());
        }
    }

    protected XmlReadHandler loadHandlerClass(String string) throws XmlReaderException {
        try {
            Class clazz = this.loadClass(string);
            return (XmlReadHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new XmlReaderException("LoadHanderClass: Unable to instantiate " + string, exception);
        }
    }

    protected Class loadClass(String string) throws XmlReaderException {
        if (string == null) {
            throw new XmlReaderException("LoadHanderClass: Class name not defined");
        }
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
            return clazz;
        }
        catch (Exception exception) {
            throw new XmlReaderException("LoadHanderClass: Unable to load " + string, exception);
        }
    }

    public Object getResult() throws SAXException {
        if (this.rootHandler != null) {
            try {
                return this.rootHandler.getObject();
            }
            catch (XmlReaderException xmlReaderException) {
                throw new ElementDefinitionException(xmlReaderException);
            }
        }
        return null;
    }
}

