/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jfree.xml.factory.objects.BeanObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class SimpleDateFormatObjectDescription
extends BeanObjectDescription {
    public SimpleDateFormatObjectDescription() {
        this(SimpleDateFormat.class);
    }

    public SimpleDateFormatObjectDescription(Class clazz) {
        this(clazz, true);
    }

    public SimpleDateFormatObjectDescription(Class clazz, boolean bl) {
        super(clazz, false);
        this.setParameterDefinition("2DigitYearStart", Date.class);
        this.setParameterDefinition("calendar", Calendar.class);
        this.setParameterDefinition("dateFormatSymbols", DateFormatSymbols.class);
        this.setParameterDefinition("lenient", Boolean.TYPE);
        this.setParameterDefinition("numberFormat", NumberFormat.class);
        this.setParameterDefinition("localizedPattern", String.class);
        this.setParameterDefinition("pattern", String.class);
        this.ignoreParameter("localizedPattern");
        this.ignoreParameter("pattern");
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        super.setParameterFromObject(object);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        this.setParameter("localizedPattern", simpleDateFormat.toLocalizedPattern());
        this.setParameter("pattern", simpleDateFormat.toPattern());
    }

    public Object createObject() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.createObject();
        if (this.getParameter("pattern") != null) {
            simpleDateFormat.applyPattern((String)this.getParameter("pattern"));
        }
        if (this.getParameter("localizedPattern") != null) {
            simpleDateFormat.applyLocalizedPattern((String)this.getParameter("localizedPattern"));
        }
        return simpleDateFormat;
    }
}

