/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class CharacterObjectDescription
extends AbstractObjectDescription {
    public CharacterObjectDescription() {
        super(Character.class);
        this.setParameterDefinition("value", String.class);
    }

    public Object createObject() {
        String string = (String)this.getParameter("value");
        if (string == null) {
            return null;
        }
        if (string.length() > 0) {
            return new Character(string.charAt(0));
        }
        return null;
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (!(object instanceof Character)) {
            throw new ObjectFactoryException("The given object is no java.lang.Character.");
        }
        this.setParameter("value", String.valueOf(object));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractObjectDescription)) {
            return false;
        }
        AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)object;
        if (Character.TYPE.equals(abstractObjectDescription.getObjectClass())) {
            return true;
        }
        return Character.class.equals((Object)abstractObjectDescription.getObjectClass());
    }

    public int hashCode() {
        return this.getObjectClass().hashCode();
    }
}

