/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.PaintList;

public class PaintListTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PaintListTests.class);
    }

    public PaintListTests(String string) {
        super(string);
    }

    public void testEquals() {
        PaintList paintList = new PaintList();
        paintList.setPaint(0, Color.red);
        paintList.setPaint(1, Color.blue);
        paintList.setPaint(2, null);
        PaintList paintList2 = new PaintList();
        paintList2.setPaint(0, Color.red);
        paintList2.setPaint(1, Color.blue);
        paintList2.setPaint(2, null);
        PaintListTests.assertTrue((boolean)paintList.equals(paintList2));
        PaintListTests.assertTrue((boolean)paintList2.equals(paintList2));
    }

    public void testEquals2() {
        PaintList paintList = new PaintList();
        Color color = new Color(200, 200, 200);
        paintList.setPaint(0, color);
        PaintList paintList2 = new PaintList();
        Color color2 = new Color(200, 200, 200);
        paintList2.setPaint(0, color2);
        PaintListTests.assertEquals((Object)paintList, (Object)paintList2);
    }

    public void testCloning() {
        PaintList paintList = new PaintList();
        paintList.setPaint(0, Color.red);
        paintList.setPaint(1, Color.blue);
        paintList.setPaint(2, null);
        PaintList paintList2 = null;
        try {
            paintList2 = (PaintList)paintList.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("PaintListTests.testCloning: failed to clone.");
        }
        PaintListTests.assertTrue((paintList != paintList2 ? 1 : 0) != 0);
        PaintListTests.assertTrue((paintList.getClass() == paintList2.getClass() ? 1 : 0) != 0);
        PaintListTests.assertTrue((boolean)paintList.equals(paintList2));
        paintList2.setPaint(0, Color.green);
        PaintListTests.assertFalse((boolean)paintList.equals(paintList2));
    }

    public void testSerialization() {
        PaintList paintList = new PaintList();
        paintList.setPaint(0, Color.red);
        paintList.setPaint(1, Color.blue);
        paintList.setPaint(2, null);
        PaintList paintList2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(paintList);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            paintList2 = (PaintList)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        PaintListTests.assertEquals((Object)paintList, paintList2);
    }
}

