/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ObjectUtilities;

public class ObjectUtilitiesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ObjectUtilitiesTests.class);
    }

    public ObjectUtilitiesTests(String string) {
        super(string);
    }

    public void testCloneObject() throws CloneNotSupportedException {
        Object object;
        boolean bl = false;
        Object object2 = "Hello World";
        try {
            object = ObjectUtilities.clone(object2);
            bl = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl = true;
        }
        ObjectUtilitiesTests.assertTrue((boolean)bl);
        bl = false;
        object2 = new Integer(123);
        try {
            object = ObjectUtilities.clone(object2);
            bl = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl = true;
        }
        ObjectUtilitiesTests.assertTrue((boolean)bl);
        object2 = new Point(1, 2);
        object = ObjectUtilities.clone(object2);
        ObjectUtilitiesTests.assertEquals((Object)object2, (Object)object);
        object2 = null;
        try {
            object = ObjectUtilities.clone(object2);
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        ObjectUtilitiesTests.assertTrue((boolean)bl);
    }

    public void testDeepClone() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Collection collection = null;
        try {
            collection = ObjectUtilities.deepClone(arrayList);
            ObjectUtilitiesTests.assertTrue((boolean)collection.isEmpty());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ObjectUtilitiesTests.assertTrue((boolean)false);
        }
        arrayList = new ArrayList();
        arrayList.add(new Point(1, 2));
        arrayList.add(new Point(3, 4));
        try {
            collection = ObjectUtilities.deepClone(arrayList);
            ObjectUtilitiesTests.assertEquals((int)2, (int)collection.size());
            ObjectUtilitiesTests.assertTrue((boolean)collection.contains(new Point(1, 2)));
            ObjectUtilitiesTests.assertTrue((boolean)collection.contains(new Point(3, 4)));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ObjectUtilitiesTests.assertTrue((boolean)false);
        }
        arrayList = new ArrayList();
        arrayList.add(new Point(1, 2));
        arrayList.add(null);
        arrayList.add(new Point(3, 4));
        try {
            collection = ObjectUtilities.deepClone(arrayList);
            ObjectUtilitiesTests.assertEquals((int)3, (int)collection.size());
            ObjectUtilitiesTests.assertTrue((boolean)collection.contains(new Point(1, 2)));
            ObjectUtilitiesTests.assertTrue((boolean)collection.contains(new Point(3, 4)));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ObjectUtilitiesTests.assertTrue((boolean)false);
        }
        arrayList.clear();
        arrayList.add("S1");
        arrayList.add("S2");
        try {
            collection = ObjectUtilities.deepClone(arrayList);
            ObjectUtilitiesTests.assertTrue((boolean)false);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ObjectUtilitiesTests.assertTrue((boolean)true);
        }
        try {
            collection = ObjectUtilities.deepClone(null);
            ObjectUtilitiesTests.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ObjectUtilitiesTests.assertTrue((boolean)true);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ObjectUtilitiesTests.assertTrue((boolean)false);
        }
    }
}

