/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ArrayUtilities;

public class ArrayUtilitiesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ArrayUtilitiesTests.class);
    }

    public ArrayUtilitiesTests(String string) {
        super(string);
    }

    public void testHasDuplicateItems() {
        Object[] objectArray = new Object[]{"1", "2", "3"};
        Object[] objectArray2 = new Object[]{"1", "1", "3"};
        Object[] objectArray3 = new Object[]{null, "2", null};
        ArrayUtilitiesTests.assertFalse((boolean)ArrayUtilities.hasDuplicateItems(objectArray));
        ArrayUtilitiesTests.assertTrue((boolean)ArrayUtilities.hasDuplicateItems(objectArray2));
        ArrayUtilitiesTests.assertFalse((boolean)ArrayUtilities.hasDuplicateItems(objectArray3));
    }

    public void testEqualReferencesInArrays() {
        Object[] objectArray = new Object[]{};
        Object[] objectArray2 = new Object[]{};
        Object[] objectArray3 = new Object[]{null};
        Object[] objectArray4 = new Object[]{null};
        Object[] objectArray5 = new Object[]{"A"};
        Object[] objectArray6 = new Object[]{"A"};
        Object[] objectArray7 = new Object[]{"A", "B"};
        Object[] objectArray8 = new Object[]{"A", "B"};
        Object[] objectArray9 = new Object[]{"A", null};
        Object[] objectArray10 = new Object[]{"A", null};
        ArrayUtilitiesTests.assertTrue((boolean)ArrayUtilities.equalReferencesInArrays(objectArray, objectArray2));
        ArrayUtilitiesTests.assertFalse((boolean)ArrayUtilities.equalReferencesInArrays(objectArray, objectArray3));
        ArrayUtilitiesTests.assertTrue((boolean)ArrayUtilities.equalReferencesInArrays(objectArray3, objectArray4));
        ArrayUtilitiesTests.assertFalse((boolean)ArrayUtilities.equalReferencesInArrays(objectArray3, objectArray5));
        ArrayUtilitiesTests.assertTrue((boolean)ArrayUtilities.equalReferencesInArrays(objectArray5, objectArray6));
        ArrayUtilitiesTests.assertFalse((boolean)ArrayUtilities.equalReferencesInArrays(objectArray5, objectArray7));
        ArrayUtilitiesTests.assertTrue((boolean)ArrayUtilities.equalReferencesInArrays(objectArray7, objectArray8));
        ArrayUtilitiesTests.assertFalse((boolean)ArrayUtilities.equalReferencesInArrays(objectArray7, objectArray9));
        ArrayUtilitiesTests.assertTrue((boolean)ArrayUtilities.equalReferencesInArrays(objectArray9, objectArray10));
    }
}

