/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class PaintUtilities {
    private PaintUtilities() {
    }

    public static boolean equal(Paint paint, Paint paint2) {
        if (paint == null) {
            return paint2 == null;
        }
        if (paint2 == null) {
            return false;
        }
        boolean bl = false;
        if (paint instanceof GradientPaint && paint2 instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            GradientPaint gradientPaint2 = (GradientPaint)paint2;
            bl = ObjectUtilities.equal(gradientPaint.getColor1(), gradientPaint2.getColor1()) && ObjectUtilities.equal(gradientPaint.getColor2(), gradientPaint2.getColor2()) && ObjectUtilities.equal(gradientPaint.getPoint1(), gradientPaint2.getPoint1()) && ObjectUtilities.equal(gradientPaint.getPoint2(), gradientPaint2.getPoint2()) && gradientPaint.isCyclic() == gradientPaint2.isCyclic() && gradientPaint.getTransparency() == gradientPaint.getTransparency();
        } else {
            bl = paint.equals(paint2);
        }
        return bl;
    }

    public static String colorToString(Color color) {
        Object object;
        try {
            object = Color.class.getFields();
            for (int i = 0; i < ((Field[])object).length; ++i) {
                Field field = object[i];
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                String string = field.getName();
                Object object2 = field.get(null);
                if (!(object2 instanceof Color) || !color.equals(object2)) continue;
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        StringBuffer stringBuffer = new StringBuffer(7);
        stringBuffer.append("#");
        int n = 6 - ((String)object).length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append((String)object);
        return stringBuffer.toString();
    }

    public static Color stringToColor(String string) {
        if (string == null) {
            return Color.black;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Field field = Color.class.getField(string);
                return (Color)field.get(null);
            }
            catch (Exception exception) {
                Log.info("No such Color : " + string);
                return Color.black;
            }
        }
    }
}

