/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.util.ObjectUtilities;

public class ObjectTable
implements Serializable {
    private static final long serialVersionUID = -3968322452944912066L;
    private int rows;
    private int columns;
    private transient Object[][] data;
    private int rowIncrement;
    private int columnIncrement;

    public ObjectTable() {
        this(5, 5);
    }

    public ObjectTable(int n) {
        this(n, n);
    }

    public ObjectTable(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        this.rows = 0;
        this.columns = 0;
        this.rowIncrement = n;
        this.columnIncrement = n2;
        this.data = new Object[n][];
    }

    public int getColumnIncrement() {
        return this.columnIncrement;
    }

    public int getRowIncrement() {
        return this.rowIncrement;
    }

    protected void ensureRowCapacity(int n) {
        if (n >= this.data.length) {
            Object[][] objectArrayArray = new Object[n + this.rowIncrement][];
            System.arraycopy(this.data, 0, objectArrayArray, 0, this.data.length);
            this.data = objectArrayArray;
        }
    }

    public void ensureCapacity(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Row is invalid. " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Column is invalid. " + n2);
        }
        this.ensureRowCapacity(n);
        Object[] objectArray = this.data[n];
        if (objectArray == null) {
            Object[] objectArray2 = new Object[Math.max(n2 + 1, this.columnIncrement)];
            this.data[n] = objectArray2;
        } else if (n2 >= objectArray.length) {
            Object[] objectArray3 = new Object[n2 + this.columnIncrement];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            this.data[n] = objectArray3;
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    protected Object getObject(int n, int n2) {
        if (n < this.data.length) {
            Object[] objectArray = this.data[n];
            if (objectArray == null) {
                return null;
            }
            if (n2 < objectArray.length) {
                return objectArray[n2];
            }
        }
        return null;
    }

    protected void setObject(int n, int n2, Object object) {
        this.ensureCapacity(n, n2);
        this.data[n][n2] = object;
        this.rows = Math.max(this.rows, n + 1);
        this.columns = Math.max(this.columns, n2 + 1);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectTable)) {
            return false;
        }
        ObjectTable objectTable = (ObjectTable)object;
        if (this.getRowCount() != objectTable.getRowCount()) {
            return false;
        }
        if (this.getColumnCount() != objectTable.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (ObjectUtilities.equal(this.getObject(i, j), objectTable.getObject(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.rows;
        n = 29 * n + this.columns;
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.data.length;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.data[i];
            objectOutputStream.writeBoolean(objectArray != null);
            if (objectArray == null) continue;
            int n2 = objectArray.length;
            objectOutputStream.writeInt(n2);
            for (int j = 0; j < n2; ++j) {
                this.writeSerializedData(objectOutputStream, objectArray[j]);
            }
        }
    }

    protected void writeSerializedData(ObjectOutputStream objectOutputStream, Object object) throws IOException {
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = new Object[n][];
        for (int i = 0; i < n; ++i) {
            boolean bl = objectInputStream.readBoolean();
            if (!bl) continue;
            int n2 = objectInputStream.readInt();
            Object[] objectArray = new Object[n2];
            this.data[i] = objectArray;
            for (int j = 0; j < n2; ++j) {
                objectArray[j] = this.readSerializedData(objectInputStream);
            }
        }
    }

    protected Object readSerializedData(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        return objectInputStream.readObject();
    }

    public void clear() {
        this.rows = 0;
        this.columns = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            Arrays.fill(this.data[i], null);
        }
    }
}

