/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Spacer
implements Serializable {
    private static final long serialVersionUID = 1464655984225158198L;
    public static final int RELATIVE = 0;
    public static final int ABSOLUTE = 1;
    public static final Spacer NO_SPACE = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
    private int type;
    private double left;
    private double right;
    private double top;
    private double bottom;

    public Spacer(int n, double d, double d2, double d3, double d4) {
        this.type = n;
        this.left = d;
        this.top = d2;
        this.right = d3;
        this.bottom = d4;
    }

    public double getLeftSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.left;
        } else if (this.type == 0) {
            d2 = this.left * d;
        }
        return d2;
    }

    public double getRightSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.right;
        } else if (this.type == 0) {
            d2 = this.right * d;
        }
        return d2;
    }

    public double getTopSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.top;
        } else if (this.type == 0) {
            d2 = this.top * d;
        }
        return d2;
    }

    public double getBottomSpace(double d) {
        double d2 = 0.0;
        if (this.type == 1) {
            d2 = this.bottom;
        } else if (this.type == 0) {
            d2 = this.bottom * d;
        }
        return d2;
    }

    public double calculateExtendedWidth(double d) {
        double d2 = d;
        if (this.type == 1) {
            d2 = d2 + this.left + this.right;
        } else if (this.type == 0) {
            d2 = d2 + this.left * d + this.right * d;
        }
        return d2;
    }

    public double calculateExtendedHeight(double d) {
        double d2 = d;
        if (this.type == 1) {
            d2 = d2 + this.top + this.bottom;
        } else if (this.type == 0) {
            d2 = d2 + this.top * d + this.bottom * d;
        }
        return d2;
    }

    public void trim(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getHeight();
        double d4 = rectangle2D.getWidth();
        double d5 = this.getLeftSpace(d4);
        double d6 = this.getRightSpace(d4);
        double d7 = this.getTopSpace(d3);
        double d8 = this.getBottomSpace(d3);
        rectangle2D.setRect(d + d5, d2 + d7, d4 - d5 - d6, d3 - d7 - d8);
    }

    public double trimWidth(double d) {
        return d - this.getLeftSpace(d) - this.getRightSpace(d);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Spacer)) {
            return false;
        }
        Spacer spacer = (Spacer)object;
        if (this.type != spacer.type) {
            return false;
        }
        if (this.left != spacer.left) {
            return false;
        }
        if (this.right != spacer.right) {
            return false;
        }
        if (this.top != spacer.top) {
            return false;
        }
        return this.bottom == spacer.bottom;
    }

    public int hashCode() {
        int n = this.type;
        long l = this.left != 0.0 ? Double.doubleToLongBits(this.left) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.right != 0.0 ? Double.doubleToLongBits(this.right) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.top != 0.0 ? Double.doubleToLongBits(this.top) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.bottom != 0.0 ? Double.doubleToLongBits(this.bottom) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

