/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jfree.ui.Size2D;

public final class RectangleAnchor
implements Serializable {
    private static final long serialVersionUID = -2457494205644416327L;
    public static final RectangleAnchor CENTER = new RectangleAnchor("RectangleAnchor.CENTER");
    public static final RectangleAnchor TOP = new RectangleAnchor("RectangleAnchor.TOP");
    public static final RectangleAnchor TOP_LEFT = new RectangleAnchor("RectangleAnchor.TOP_LEFT");
    public static final RectangleAnchor TOP_RIGHT = new RectangleAnchor("RectangleAnchor.TOP_RIGHT");
    public static final RectangleAnchor BOTTOM = new RectangleAnchor("RectangleAnchor.BOTTOM");
    public static final RectangleAnchor BOTTOM_LEFT = new RectangleAnchor("RectangleAnchor.BOTTOM_LEFT");
    public static final RectangleAnchor BOTTOM_RIGHT = new RectangleAnchor("RectangleAnchor.BOTTOM_RIGHT");
    public static final RectangleAnchor LEFT = new RectangleAnchor("RectangleAnchor.LEFT");
    public static final RectangleAnchor RIGHT = new RectangleAnchor("RectangleAnchor.RIGHT");
    private String name;

    private RectangleAnchor(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RectangleAnchor)) {
            return false;
        }
        RectangleAnchor rectangleAnchor = (RectangleAnchor)object;
        return this.name.equals(rectangleAnchor.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Point2D coordinates(Rectangle2D rectangle2D, RectangleAnchor rectangleAnchor) {
        Point2D.Double double_ = new Point2D.Double();
        if (rectangleAnchor == CENTER) {
            ((Point2D)double_).setLocation(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        } else if (rectangleAnchor == TOP) {
            ((Point2D)double_).setLocation(rectangle2D.getCenterX(), rectangle2D.getMinY());
        } else if (rectangleAnchor == BOTTOM) {
            ((Point2D)double_).setLocation(rectangle2D.getCenterX(), rectangle2D.getMaxY());
        } else if (rectangleAnchor == LEFT) {
            ((Point2D)double_).setLocation(rectangle2D.getMinX(), rectangle2D.getCenterY());
        } else if (rectangleAnchor == RIGHT) {
            ((Point2D)double_).setLocation(rectangle2D.getMaxX(), rectangle2D.getCenterY());
        } else if (rectangleAnchor == TOP_LEFT) {
            ((Point2D)double_).setLocation(rectangle2D.getMinX(), rectangle2D.getMinY());
        } else if (rectangleAnchor == TOP_RIGHT) {
            ((Point2D)double_).setLocation(rectangle2D.getMaxX(), rectangle2D.getMinY());
        } else if (rectangleAnchor == BOTTOM_LEFT) {
            ((Point2D)double_).setLocation(rectangle2D.getMinX(), rectangle2D.getMaxY());
        } else if (rectangleAnchor == BOTTOM_RIGHT) {
            ((Point2D)double_).setLocation(rectangle2D.getMaxX(), rectangle2D.getMaxY());
        }
        return double_;
    }

    public static Rectangle2D createRectangle(Size2D size2D, double d, double d2, RectangleAnchor rectangleAnchor) {
        Rectangle2D.Double double_ = null;
        double d3 = size2D.getWidth();
        double d4 = size2D.getHeight();
        if (rectangleAnchor == CENTER) {
            double_ = new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == TOP) {
            double_ = new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == BOTTOM) {
            double_ = new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == LEFT) {
            double_ = new Rectangle2D.Double(d, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == RIGHT) {
            double_ = new Rectangle2D.Double(d - d3, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == TOP_LEFT) {
            double_ = new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == TOP_RIGHT) {
            double_ = new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == BOTTOM_LEFT) {
            double_ = new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        } else if (rectangleAnchor == BOTTOM_RIGHT) {
            double_ = new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        }
        return double_;
    }

    private Object readResolve() throws ObjectStreamException {
        RectangleAnchor rectangleAnchor = null;
        if (this.equals(CENTER)) {
            rectangleAnchor = CENTER;
        } else if (this.equals(TOP)) {
            rectangleAnchor = TOP;
        } else if (this.equals(BOTTOM)) {
            rectangleAnchor = BOTTOM;
        } else if (this.equals(LEFT)) {
            rectangleAnchor = LEFT;
        } else if (this.equals(RIGHT)) {
            rectangleAnchor = RIGHT;
        } else if (this.equals(TOP_LEFT)) {
            rectangleAnchor = TOP_LEFT;
        } else if (this.equals(TOP_RIGHT)) {
            rectangleAnchor = TOP_RIGHT;
        } else if (this.equals(BOTTOM_LEFT)) {
            rectangleAnchor = BOTTOM_LEFT;
        } else if (this.equals(BOTTOM_RIGHT)) {
            rectangleAnchor = BOTTOM_RIGHT;
        }
        return rectangleAnchor;
    }
}

