/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KeyedComboBoxModel
implements ComboBoxModel {
    private int selectedItem;
    private ArrayList data = new ArrayList();
    private ArrayList listdatalistener = new ArrayList();
    private transient ListDataListener[] tempListeners;

    public KeyedComboBoxModel() {
    }

    public KeyedComboBoxModel(Object[] objectArray, Object[] objectArray2) {
        this();
        this.setData(objectArray, objectArray2);
    }

    public void setData(Object[] objectArray, Object[] objectArray2) {
        if (objectArray2.length != objectArray.length) {
            throw new IllegalArgumentException("Values and text must have the same length.");
        }
        this.data.clear();
        this.data.ensureCapacity(objectArray.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            this.add(objectArray[i], objectArray2[i]);
        }
        this.selectedItem = -1;
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.data.size() - 1);
        this.fireListDataEvent(listDataEvent);
    }

    protected synchronized void fireListDataEvent(ListDataEvent listDataEvent) {
        if (this.tempListeners == null) {
            this.tempListeners = this.listdatalistener.toArray(new ListDataListener[this.listdatalistener.size()]);
        }
        for (int i = 0; i < this.tempListeners.length; ++i) {
            ListDataListener listDataListener = this.tempListeners[i];
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    public Object getSelectedItem() {
        if (this.selectedItem >= this.data.size()) {
            return null;
        }
        if (this.selectedItem < 0) {
            return null;
        }
        ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(this.selectedItem);
        return comboBoxItemPair.getValue();
    }

    public void setSelectedKey(Object object) {
        int n;
        this.selectedItem = object == null ? -1 : (n = this.findDataElementIndex(object));
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    public void setSelectedItem(Object object) {
        int n;
        this.selectedItem = object == null ? -1 : (n = this.findElementIndex(object));
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    public synchronized void addListDataListener(ListDataListener listDataListener) {
        this.listdatalistener.add(listDataListener);
        this.tempListeners = null;
    }

    public Object getElementAt(int n) {
        if (n >= this.data.size()) {
            return null;
        }
        ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(n);
        if (comboBoxItemPair == null) {
            return null;
        }
        return comboBoxItemPair.getValue();
    }

    public Object getKeyAt(int n) {
        if (n >= this.data.size()) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(n);
        if (comboBoxItemPair == null) {
            return null;
        }
        return comboBoxItemPair.getKey();
    }

    public Object getSelectedKey() {
        return this.getKeyAt(this.selectedItem);
    }

    public int getSize() {
        return this.data.size();
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listdatalistener.remove(listDataListener);
        this.tempListeners = null;
    }

    private int findDataElementIndex(Object object) {
        if (object == null) {
            throw new NullPointerException("Item to find must not be null");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(i);
            if (!object.equals(comboBoxItemPair.getKey())) continue;
            return i;
        }
        return -1;
    }

    public int findElementIndex(Object object) {
        if (object == null) {
            throw new NullPointerException("Item to find must not be null");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(i);
            if (!object.equals(comboBoxItemPair.getValue())) continue;
            return i;
        }
        return -1;
    }

    public void removeDataElement(Object object) {
        int n = this.findDataElementIndex(object);
        if (n == -1) {
            return;
        }
        this.data.remove(n);
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, n, n);
        this.fireListDataEvent(listDataEvent);
    }

    public void add(Object object, Object object2) {
        ComboBoxItemPair comboBoxItemPair = new ComboBoxItemPair(object, object2);
        this.data.add(comboBoxItemPair);
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, this.data.size() - 2, this.data.size() - 2);
        this.fireListDataEvent(listDataEvent);
    }

    public void clear() {
        int n = this.getSize();
        this.data.clear();
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, 0, n - 1);
        this.fireListDataEvent(listDataEvent);
    }

    private static class ComboBoxItemPair {
        private Object key;
        private Object value;

        public ComboBoxItemPair(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

