/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.threads;

import java.util.ArrayList;
import java.util.Iterator;

public class ReaderWriterLock {
    private ArrayList waiters = new ArrayList();

    public synchronized void lockRead() {
        ReaderWriterNode readerWriterNode;
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            readerWriterNode = new ReaderWriterNode(thread, 0);
            this.waiters.add(readerWriterNode);
        } else {
            readerWriterNode = (ReaderWriterNode)this.waiters.get(n);
        }
        while (this.getIndex(thread) > this.firstWriter()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                System.err.println("ReaderWriterLock.lockRead(): exception.");
                System.err.print(exception.getMessage());
            }
        }
        ++readerWriterNode.nAcquires;
    }

    public synchronized void lockWrite() {
        ReaderWriterNode readerWriterNode;
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            readerWriterNode = new ReaderWriterNode(thread, 1);
            this.waiters.add(readerWriterNode);
        } else {
            readerWriterNode = (ReaderWriterNode)this.waiters.get(n);
            if (readerWriterNode.state == 0) {
                throw new IllegalArgumentException("Upgrade lock");
            }
            readerWriterNode.state = 1;
        }
        while (this.getIndex(thread) != 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                System.err.println("ReaderWriterLock.lockWrite(): exception.");
                System.err.print(exception.getMessage());
            }
        }
        ++readerWriterNode.nAcquires;
    }

    public synchronized void unlock() {
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n > this.firstWriter()) {
            throw new IllegalArgumentException("Lock not held");
        }
        ReaderWriterNode readerWriterNode = (ReaderWriterNode)this.waiters.get(n);
        --readerWriterNode.nAcquires;
        if (readerWriterNode.nAcquires == 0) {
            this.waiters.remove(n);
        }
        this.notifyAll();
    }

    private int firstWriter() {
        Iterator iterator = this.waiters.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ReaderWriterNode readerWriterNode = (ReaderWriterNode)iterator.next();
            if (readerWriterNode.state == 1) {
                return n;
            }
            ++n;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread thread) {
        Iterator iterator = this.waiters.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ReaderWriterNode readerWriterNode = (ReaderWriterNode)iterator.next();
            if (readerWriterNode.t == thread) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static class ReaderWriterNode {
        protected static final int READER = 0;
        protected static final int WRITER = 1;
        protected Thread t;
        protected int state;
        protected int nAcquires;

        private ReaderWriterNode(Thread thread, int n) {
            this.t = thread;
            this.state = n;
            this.nAcquires = 0;
        }
    }
}

