/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.text.TextFragment;

public class TextFragmentTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TextFragmentTests.class);
    }

    public TextFragmentTests(String string) {
        super(string);
    }

    public void testEquals() {
        TextFragment textFragment = new TextFragment("Test");
        TextFragment textFragment2 = new TextFragment("Test");
        TextFragmentTests.assertTrue((boolean)textFragment.equals(textFragment2));
        TextFragmentTests.assertTrue((boolean)textFragment2.equals(textFragment));
        textFragment = new TextFragment("Test 1");
        TextFragmentTests.assertFalse((boolean)textFragment.equals(textFragment2));
        textFragment2 = new TextFragment("Test 1");
        TextFragmentTests.assertTrue((boolean)textFragment.equals(textFragment2));
        textFragment = new TextFragment("Test 1", new Font("Arial", 1, 11));
        TextFragmentTests.assertFalse((boolean)textFragment.equals(textFragment2));
        textFragment2 = new TextFragment("Test 1", new Font("Arial", 1, 11));
        TextFragmentTests.assertTrue((boolean)textFragment.equals(textFragment2));
        textFragment = new TextFragment("Test 1", new Font("Arial", 1, 11), Color.red);
        TextFragmentTests.assertFalse((boolean)textFragment.equals(textFragment2));
        textFragment2 = new TextFragment("Test 1", new Font("Arial", 1, 11), Color.red);
        TextFragmentTests.assertTrue((boolean)textFragment.equals(textFragment2));
    }

    public void testSerialization() {
        TextFragment textFragment = new TextFragment("Test");
        TextFragment textFragment2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(textFragment);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            textFragment2 = (TextFragment)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TextFragmentTests.assertEquals((Object)textFragment, textFragment2);
    }
}

