/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextLine;
import org.jfree.ui.RectangleInsets;

public class TextBoxTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TextBoxTests.class);
    }

    public TextBoxTests(String string) {
        super(string);
    }

    public void testEquals() {
        TextBox textBox = new TextBox("Hello");
        TextBox textBox2 = new TextBox("Hello");
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        TextBoxTests.assertTrue((boolean)textBox2.equals(textBox));
        textBox.setOutlinePaint(Color.blue);
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        textBox2.setOutlinePaint(Color.blue);
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        textBox.setOutlineStroke(new BasicStroke(1.1f));
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        textBox2.setOutlineStroke(new BasicStroke(1.1f));
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        textBox.setInteriorGap(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        textBox2.setInteriorGap(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        textBox.setBackgroundPaint(Color.blue);
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        textBox2.setBackgroundPaint(Color.blue);
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        textBox.setShadowPaint(Color.blue);
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        textBox2.setShadowPaint(Color.blue);
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        textBox.setShadowXOffset(1.0);
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        textBox2.setShadowXOffset(1.0);
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        textBox.setShadowYOffset(1.0);
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        textBox2.setShadowYOffset(1.0);
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
        TextBlock textBlock = new TextBlock();
        textBlock.addLine(new TextLine("Testing"));
        textBox.setTextBlock(textBlock);
        TextBoxTests.assertFalse((boolean)textBox.equals(textBox2));
        TextBlock textBlock2 = new TextBlock();
        textBlock2.addLine(new TextLine("Testing"));
        textBox2.setTextBlock(textBlock2);
        TextBoxTests.assertTrue((boolean)textBox.equals(textBox2));
    }

    public void testSerialization() {
        TextBox textBox = new TextBox("Hello");
        TextBox textBox2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(textBox);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            textBox2 = (TextBox)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TextBoxTests.assertEquals((Object)textBox, textBox2);
    }
}

