/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io.junit;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ShapeUtilities;

public class SerialUtilitiesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SerialUtilitiesTests.class);
    }

    public SerialUtilitiesTests(String string) {
        super(string);
    }

    public void testIsSerializable() {
        SerialUtilitiesTests.assertTrue((boolean)SerialUtilities.isSerializable(Color.class));
        SerialUtilitiesTests.assertTrue((boolean)SerialUtilities.isSerializable(ColorUIResource.class));
        SerialUtilitiesTests.assertFalse((boolean)SerialUtilities.isSerializable(GradientPaint.class));
        SerialUtilitiesTests.assertFalse((boolean)SerialUtilities.isSerializable(TexturePaint.class));
    }

    public void testColorSerialization() {
        Color color = Color.blue;
        Paint paint = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writePaint(color, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            paint = SerialUtilities.readPaint(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertEquals((Object)color, paint);
    }

    public void testColorUIResourceSerialization() {
        Color color = UIManager.getColor("Panel.background");
        Paint paint = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writePaint(color, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            paint = SerialUtilities.readPaint(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            SerialUtilitiesTests.fail((String)exception.toString());
        }
        SerialUtilitiesTests.assertEquals((Object)color, paint);
    }

    public void testGradientPaintSerialization() {
        Object object;
        Object object2;
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.blue, 100.0f, 200.0f, Color.red);
        Paint paint = null;
        try {
            object2 = new ByteArrayOutputStream();
            object = new ObjectOutputStream((OutputStream)object2);
            SerialUtilities.writePaint(gradientPaint, (ObjectOutputStream)object);
            ((ObjectOutputStream)object).close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            paint = SerialUtilities.readPaint(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        object2 = gradientPaint;
        object = (GradientPaint)paint;
        SerialUtilitiesTests.assertEquals((Object)((GradientPaint)object2).getColor1(), (Object)((GradientPaint)object).getColor1());
        SerialUtilitiesTests.assertEquals((Object)((GradientPaint)object2).getPoint1(), (Object)((GradientPaint)object).getPoint1());
        SerialUtilitiesTests.assertEquals((Object)((GradientPaint)object2).getColor2(), (Object)((GradientPaint)object).getColor2());
        SerialUtilitiesTests.assertEquals((Object)((GradientPaint)object2).getPoint2(), (Object)((GradientPaint)object).getPoint2());
        SerialUtilitiesTests.assertEquals((boolean)((GradientPaint)object2).isCyclic(), (boolean)((GradientPaint)object).isCyclic());
    }

    public void testTexturePaintSerialization() {
        TexturePaint texturePaint = new TexturePaint(new BufferedImage(5, 5, 1), new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0));
        Paint paint = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writePaint(texturePaint, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            paint = SerialUtilities.readPaint(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertNull(paint);
    }

    public void testLine2DFloatSerialization() {
        Line2D.Float float_ = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Line2D line2D = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writeShape(float_, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            line2D = (Line2D)SerialUtilities.readShape(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(float_, line2D));
    }

    public void testLine2DDoubleSerialization() {
        Line2D.Double double_ = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        Line2D line2D = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writeShape(double_, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            line2D = (Line2D)SerialUtilities.readShape(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(double_, line2D));
    }

    public void testRectangle2DFloatSerialization() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Rectangle2D rectangle2D = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writeShape(float_, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            rectangle2D = (Rectangle2D)SerialUtilities.readShape(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(float_, rectangle2D));
    }

    public void testRectangle2DDoubleSerialization() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        Rectangle2D rectangle2D = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writeShape(double_, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            rectangle2D = (Rectangle2D)SerialUtilities.readShape(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(double_, rectangle2D));
    }

    public void testArc2DFloatSerialization() {
        Arc2D.Float float_ = new Arc2D.Float(1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 2);
        Arc2D arc2D = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writeShape(float_, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            arc2D = (Arc2D)SerialUtilities.readShape(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(float_, arc2D));
    }

    public void testArc2DDoubleSerialization() {
        Arc2D.Double double_ = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        Arc2D arc2D = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writeShape(double_, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            arc2D = (Arc2D)SerialUtilities.readShape(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(double_, arc2D));
    }

    public void testGeneralPathSerialization() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(1.0f, 2.0f);
        generalPath.lineTo(3.0f, 4.0f);
        generalPath.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath.closePath();
        GeneralPath generalPath2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            SerialUtilities.writeShape(generalPath, objectOutputStream);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            generalPath2 = (GeneralPath)SerialUtilities.readShape(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SerialUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(generalPath, generalPath2));
    }
}

