/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XYSeriesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYSeriesCollectionTests.class);
    }

    public XYSeriesCollectionTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.0, 1.1);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series"));
        xYSeries2.add(1.0, 1.1);
        XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
        xYSeriesCollection2.addSeries(xYSeries2);
        XYSeriesCollectionTests.assertTrue((boolean)xYSeriesCollection.equals(xYSeriesCollection2));
        XYSeriesCollectionTests.assertTrue((boolean)xYSeriesCollection2.equals(xYSeriesCollection));
        xYSeriesCollection.addSeries(new XYSeries((Comparable)((Object)"Empty Series")));
        XYSeriesCollectionTests.assertFalse((boolean)xYSeriesCollection.equals(xYSeriesCollection2));
        xYSeriesCollection2.addSeries(new XYSeries((Comparable)((Object)"Empty Series")));
        XYSeriesCollectionTests.assertTrue((boolean)xYSeriesCollection.equals(xYSeriesCollection2));
    }

    public void testCloning() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.0, 1.1);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        XYSeriesCollection xYSeriesCollection2 = null;
        try {
            xYSeriesCollection2 = (XYSeriesCollection)xYSeriesCollection.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYSeriesCollectionTests.assertTrue((xYSeriesCollection != xYSeriesCollection2 ? 1 : 0) != 0);
        XYSeriesCollectionTests.assertTrue((xYSeriesCollection.getClass() == xYSeriesCollection2.getClass() ? 1 : 0) != 0);
        XYSeriesCollectionTests.assertTrue((boolean)xYSeriesCollection.equals(xYSeriesCollection2));
    }

    public void testSerialization() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.0, 1.1);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        XYSeriesCollection xYSeriesCollection2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYSeriesCollection);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYSeriesCollection2 = (XYSeriesCollection)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYSeriesCollectionTests.assertEquals((Object)xYSeriesCollection, xYSeriesCollection2);
    }

    public void test1170825() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series1"));
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        try {
            xYSeriesCollection.getSeries(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            XYSeriesCollectionTests.assertTrue((boolean)false);
        }
    }
}

