/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.XYDataItem;

public class XYDataItemTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYDataItemTests.class);
    }

    public XYDataItemTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYDataItem xYDataItem = new XYDataItem(1.0, 1.1);
        XYDataItem xYDataItem2 = new XYDataItem(1.0, 1.1);
        XYDataItemTests.assertTrue((boolean)xYDataItem.equals(xYDataItem2));
        XYDataItemTests.assertTrue((boolean)xYDataItem2.equals(xYDataItem));
        xYDataItem.setY(new Double(9.9));
        XYDataItemTests.assertFalse((boolean)xYDataItem.equals(xYDataItem2));
        xYDataItem2.setY(new Double(9.9));
        XYDataItemTests.assertTrue((boolean)xYDataItem.equals(xYDataItem2));
    }

    public void testCloning() {
        XYDataItem xYDataItem = new XYDataItem(1.0, 1.1);
        XYDataItem xYDataItem2 = null;
        try {
            xYDataItem2 = (XYDataItem)xYDataItem.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("XYDataItemTests.testCloning: failed to clone.");
        }
        XYDataItemTests.assertTrue((xYDataItem != xYDataItem2 ? 1 : 0) != 0);
        XYDataItemTests.assertTrue((xYDataItem.getClass() == xYDataItem2.getClass() ? 1 : 0) != 0);
        XYDataItemTests.assertTrue((boolean)xYDataItem.equals(xYDataItem2));
    }

    public void testSerialization() {
        XYDataItem xYDataItem = new XYDataItem(1.0, 1.1);
        XYDataItem xYDataItem2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYDataItem);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYDataItem2 = (XYDataItem)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYDataItemTests.assertEquals((Object)xYDataItem, xYDataItem2);
    }
}

