/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class IntervalXYDelegateTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(IntervalXYDelegateTests.class);
    }

    public IntervalXYDelegateTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.2, 3.4);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        IntervalXYDelegate intervalXYDelegate = new IntervalXYDelegate(xYSeriesCollection);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series"));
        XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
        xYSeries2.add(1.2, 3.4);
        xYSeriesCollection2.addSeries(xYSeries2);
        IntervalXYDelegate intervalXYDelegate2 = new IntervalXYDelegate(xYSeriesCollection2);
        IntervalXYDelegateTests.assertTrue((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
        IntervalXYDelegateTests.assertTrue((boolean)intervalXYDelegate2.equals(intervalXYDelegate));
        intervalXYDelegate.setAutoWidth(false);
        IntervalXYDelegateTests.assertFalse((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
        intervalXYDelegate2.setAutoWidth(false);
        IntervalXYDelegateTests.assertTrue((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
        intervalXYDelegate.setIntervalPositionFactor(0.123);
        IntervalXYDelegateTests.assertFalse((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
        intervalXYDelegate2.setIntervalPositionFactor(0.123);
        IntervalXYDelegateTests.assertTrue((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
        intervalXYDelegate.setIntervalWidth(1.23);
        IntervalXYDelegateTests.assertFalse((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
        intervalXYDelegate2.setIntervalWidth(1.23);
        IntervalXYDelegateTests.assertTrue((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
    }

    public void testCloning() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.2, 3.4);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        IntervalXYDelegate intervalXYDelegate = new IntervalXYDelegate(xYSeriesCollection);
        IntervalXYDelegate intervalXYDelegate2 = null;
        try {
            intervalXYDelegate2 = (IntervalXYDelegate)intervalXYDelegate.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        IntervalXYDelegateTests.assertTrue((intervalXYDelegate != intervalXYDelegate2 ? 1 : 0) != 0);
        IntervalXYDelegateTests.assertTrue((intervalXYDelegate.getClass() == intervalXYDelegate2.getClass() ? 1 : 0) != 0);
        IntervalXYDelegateTests.assertTrue((boolean)intervalXYDelegate.equals(intervalXYDelegate2));
    }

    public void testSerialization() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.2, 3.4);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        IntervalXYDelegate intervalXYDelegate = new IntervalXYDelegate(xYSeriesCollection);
        IntervalXYDelegate intervalXYDelegate2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(intervalXYDelegate);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            intervalXYDelegate2 = (IntervalXYDelegate)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        IntervalXYDelegateTests.assertEquals((Object)intervalXYDelegate, intervalXYDelegate2);
    }
}

