/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class IntervalXYDelegate
implements DomainInfo,
Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -685166711639592857L;
    private XYDataset dataset;
    private boolean autoWidth;
    private double intervalPositionFactor;
    private double intervalWidth;
    private double autoIntervalWidth;
    private double lowerBound;
    private double upperBound;

    public IntervalXYDelegate(XYDataset xYDataset) {
        this(xYDataset, true);
    }

    public IntervalXYDelegate(XYDataset xYDataset, boolean bl) {
        this.autoWidth = bl;
        this.dataset = xYDataset;
        this.intervalPositionFactor = 0.5;
        this.autoWidth = bl;
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        this.intervalWidth = 1.0;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public void setAutoWidth(boolean bl) {
        this.autoWidth = bl;
    }

    public double getIntervalPositionFactor() {
        return this.intervalPositionFactor;
    }

    public void setIntervalPositionFactor(double d) {
        if (d < 0.0 || 1.0 < d) {
            throw new IllegalArgumentException("Argument 'd' outside valid range.");
        }
        this.intervalPositionFactor = d;
    }

    public void setIntervalWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'w' argument.");
        }
        this.intervalWidth = d;
    }

    public double getIntervalWidth() {
        if (this.isAutoWidth() && !Double.isInfinite(this.autoIntervalWidth)) {
            return this.autoIntervalWidth;
        }
        return this.intervalWidth;
    }

    public Number getStartX(int n, int n2) {
        Double d = null;
        Number number = this.dataset.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() - this.getIntervalPositionFactor() * this.getIntervalWidth());
        }
        return d;
    }

    public Number getEndX(int n, int n2) {
        Double d = null;
        Number number = this.dataset.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() + (1.0 - this.getIntervalPositionFactor()) * this.getIntervalWidth());
        }
        return d;
    }

    public double getDomainLowerBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getLowerBound();
        }
        return d;
    }

    public double getDomainUpperBound(boolean bl) {
        double d = Double.NaN;
        Range range = this.getDomainBounds(bl);
        if (range != null) {
            d = range.getUpperBound();
        }
        return d;
    }

    public Range getDomainBounds(boolean bl) {
        Range range = DatasetUtilities.iterateDomainBounds(this.dataset, bl);
        if (this.dataset.getSeriesCount() == 1 && this.dataset.getItemCount(0) == 1) {
            range = new Range(range.getLowerBound() - this.getIntervalWidth(), range.getUpperBound() + this.getIntervalWidth());
        }
        return range;
    }

    public void itemAdded(int n, int n2) {
        double d;
        double d2;
        double d3 = this.dataset.getXValue(n, n2);
        if (n2 > 0 && (d2 = d3 - (d = this.dataset.getXValue(n, n2 - 1))) < this.autoIntervalWidth) {
            this.autoIntervalWidth = d2;
            this.lowerBound = d;
            this.upperBound = d3;
        }
        if (n2 + 1 < this.dataset.getItemCount(n) && (d2 = (d = this.dataset.getXValue(n, n2 + 1)) - d3) < this.autoIntervalWidth) {
            this.autoIntervalWidth = d2;
            this.lowerBound = d3;
            this.upperBound = d;
        }
    }

    public void itemRemoved(double d) {
        if (d == this.lowerBound || d == this.upperBound) {
            this.recalculateIntervalWidth();
        }
    }

    private void recalculateIntervalWidth() {
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        int n = this.dataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            this.calculateSeries(i);
        }
    }

    private void calculateSeries(int n) {
        int n2 = this.dataset.getItemCount(n);
        int n3 = n2;
        for (int i = 1; i < n3; ++i) {
            double d = this.dataset.getXValue(n, i - 1);
            double d2 = this.dataset.getXValue(n, i);
            double d3 = d2 - d;
            if (!(d3 < this.autoIntervalWidth)) continue;
            this.autoIntervalWidth = d3;
            this.lowerBound = d;
            this.upperBound = d2;
        }
    }

    public void seriesAdded(int n) {
        this.calculateSeries(n);
    }

    public void seriesRemoved() {
        this.recalculateIntervalWidth();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalXYDelegate)) {
            return false;
        }
        IntervalXYDelegate intervalXYDelegate = (IntervalXYDelegate)object;
        if (this.autoWidth != intervalXYDelegate.autoWidth) {
            return false;
        }
        if (this.intervalPositionFactor != intervalXYDelegate.intervalPositionFactor) {
            return false;
        }
        return this.intervalWidth == intervalXYDelegate.intervalWidth;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

