/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.ObjectUtilities;

public class DefaultTableXYDataset
extends AbstractIntervalXYDataset
implements TableXYDataset,
IntervalXYDataset,
DomainInfo {
    private List data = null;
    private HashSet xPoints = null;
    private boolean propagateEvents = true;
    private boolean autoPrune = false;
    private IntervalXYDelegate intervalDelegate;

    public DefaultTableXYDataset() {
        this(false);
    }

    public DefaultTableXYDataset(boolean bl) {
        this.autoPrune = bl;
        this.data = new ArrayList();
        this.xPoints = new HashSet();
        this.intervalDelegate = new IntervalXYDelegate(this, false);
    }

    public boolean isAutoPrune() {
        return this.autoPrune;
    }

    public void addSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (xYSeries.getAllowDuplicateXValues()) {
            throw new IllegalArgumentException("Cannot accept XYSeries that allow duplicate values. Use XYSeries(seriesName, <sort>, false) constructor.");
        }
        this.updateXPoints(xYSeries);
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    private void updateXPoints(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' not permitted.");
        }
        HashSet<Number> hashSet = new HashSet<Number>();
        boolean bl = this.propagateEvents;
        this.propagateEvents = false;
        for (int i = 0; i < xYSeries.getItemCount(); ++i) {
            Number number = xYSeries.getX(i);
            hashSet.add(number);
            if (this.xPoints.contains(number)) continue;
            this.xPoints.add(number);
            int n = this.data.size();
            for (int j = 0; j < n; ++j) {
                XYSeries xYSeries2 = (XYSeries)this.data.get(j);
                if (xYSeries2.equals(xYSeries)) continue;
                xYSeries2.add(number, null);
            }
        }
        for (Number number : this.xPoints) {
            if (hashSet.contains(number)) continue;
            xYSeries.add(number, null);
        }
        this.propagateEvents = bl;
    }

    public void updateXPoints() {
        this.propagateEvents = false;
        for (int i = 0; i < this.data.size(); ++i) {
            this.updateXPoints((XYSeries)this.data.get(i));
        }
        if (this.autoPrune) {
            this.prune();
        }
        this.propagateEvents = true;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public int getItemCount() {
        if (this.xPoints == null) {
            return 0;
        }
        return this.xPoints.size();
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        return (XYSeries)this.data.get(n);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getX(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getX();
    }

    public Number getStartX(int n, int n2) {
        return this.intervalDelegate.getStartX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        return this.intervalDelegate.getEndX(n, n2);
    }

    public Number getY(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getY();
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            xYSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.xPoints.clear();
        this.intervalDelegate.seriesRemoved();
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            this.data.remove(xYSeries);
            if (this.data.size() == 0) {
                this.xPoints.clear();
            }
            this.intervalDelegate.seriesRemoved();
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        xYSeries.removeChangeListener(this);
        this.data.remove(n);
        if (this.data.size() == 0) {
            this.xPoints.clear();
        } else if (this.autoPrune) {
            this.prune();
        }
        this.intervalDelegate.seriesRemoved();
        this.fireDatasetChanged();
    }

    public void removeAllValuesForX(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        boolean bl = this.propagateEvents;
        this.propagateEvents = false;
        for (int i = 0; i < this.data.size(); ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            xYSeries.remove(number);
        }
        this.propagateEvents = bl;
        this.xPoints.remove(number);
        this.intervalDelegate.seriesRemoved();
        this.fireDatasetChanged();
    }

    protected boolean canPrune(Number number) {
        for (int i = 0; i < this.data.size(); ++i) {
            XYSeries xYSeries = (XYSeries)this.data.get(i);
            if (xYSeries.getY(xYSeries.indexOf(number)) == null) continue;
            return false;
        }
        return true;
    }

    public void prune() {
        HashSet hashSet = (HashSet)this.xPoints.clone();
        for (Number number : hashSet) {
            if (!this.canPrune(number)) continue;
            this.removeAllValuesForX(number);
        }
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        if (this.propagateEvents) {
            this.updateXPoints();
            this.fireDatasetChanged();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultTableXYDataset)) {
            return false;
        }
        DefaultTableXYDataset defaultTableXYDataset = (DefaultTableXYDataset)object;
        if (this.autoPrune != defaultTableXYDataset.autoPrune) {
            return false;
        }
        if (this.propagateEvents != defaultTableXYDataset.propagateEvents) {
            return false;
        }
        if (!this.intervalDelegate.equals(defaultTableXYDataset.intervalDelegate)) {
            return false;
        }
        return ObjectUtilities.equal(this.data, defaultTableXYDataset.data);
    }

    public int hashCode() {
        int n = this.data != null ? ((Object)this.data).hashCode() : 0;
        n = 29 * n + (this.xPoints != null ? this.xPoints.hashCode() : 0);
        n = 29 * n + (this.propagateEvents ? 1 : 0);
        n = 29 * n + (this.autoPrune ? 1 : 0);
        return n;
    }

    public double getDomainLowerBound(boolean bl) {
        return this.intervalDelegate.getDomainLowerBound(bl);
    }

    public double getDomainUpperBound(boolean bl) {
        return this.intervalDelegate.getDomainUpperBound(bl);
    }

    public Range getDomainBounds(boolean bl) {
        return this.intervalDelegate.getDomainBounds(bl);
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d) {
        this.intervalDelegate.setIntervalPositionFactor(d);
        this.fireDatasetChanged();
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d) {
        this.intervalDelegate.setIntervalWidth(d);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean bl) {
        this.intervalDelegate.setAutoWidth(bl);
        this.fireDatasetChanged();
    }
}

