/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.util.Arrays;
import java.util.Date;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.OHLCDataItem;
import org.jfree.data.xy.OHLCDataset;

public class DefaultOHLCDataset
extends AbstractXYDataset
implements OHLCDataset {
    private Comparable key;
    private OHLCDataItem[] data;

    public DefaultOHLCDataset(Comparable comparable, OHLCDataItem[] oHLCDataItemArray) {
        this.key = comparable;
        this.data = oHLCDataItemArray;
    }

    public Comparable getSeriesKey(int n) {
        return this.key;
    }

    public Number getX(int n, int n2) {
        return new Long(this.data[n2].getDate().getTime());
    }

    public Date getXDate(int n, int n2) {
        return this.data[n2].getDate();
    }

    public Number getY(int n, int n2) {
        return this.getClose(n, n2);
    }

    public Number getHigh(int n, int n2) {
        return this.data[n2].getHigh();
    }

    public double getHighValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getHigh(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getLow(int n, int n2) {
        return this.data[n2].getLow();
    }

    public double getLowValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getLow(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getOpen(int n, int n2) {
        return this.data[n2].getOpen();
    }

    public double getOpenValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getOpen(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getClose(int n, int n2) {
        return this.data[n2].getClose();
    }

    public double getCloseValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getClose(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getVolume(int n, int n2) {
        return this.data[n2].getVolume();
    }

    public double getVolumeValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getVolume(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int n) {
        return this.data.length;
    }

    public void sortDataByDate() {
        Arrays.sort(this.data);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultOHLCDataset)) {
            return false;
        }
        DefaultOHLCDataset defaultOHLCDataset = (DefaultOHLCDataset)object;
        if (!this.key.equals(defaultOHLCDataset.key)) {
            return false;
        }
        return Arrays.equals(this.data, defaultOHLCDataset.data);
    }
}

