/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TimeSeriesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TimeSeriesCollectionTests.class);
    }

    public TimeSeriesCollectionTests(String string) {
        super(string);
    }

    public void testEquals() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        TimeSeries timeSeries = new TimeSeries("Series 1");
        TimeSeries timeSeries2 = new TimeSeries("Series 2");
        boolean bl = timeSeriesCollection.equals(timeSeriesCollection2);
        TimeSeriesCollectionTests.assertTrue((String)"b1", (boolean)bl);
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.addSeries(timeSeries2);
        boolean bl2 = timeSeriesCollection.equals(timeSeriesCollection2);
        TimeSeriesCollectionTests.assertFalse((String)"b2", (boolean)bl2);
        timeSeriesCollection2.addSeries(timeSeries);
        timeSeriesCollection2.addSeries(timeSeries2);
        boolean bl3 = timeSeriesCollection.equals(timeSeriesCollection2);
        TimeSeriesCollectionTests.assertTrue((String)"b3", (boolean)bl3);
        timeSeriesCollection2.removeSeries(timeSeries2);
        boolean bl4 = timeSeriesCollection.equals(timeSeriesCollection2);
        TimeSeriesCollectionTests.assertFalse((String)"b4", (boolean)bl4);
        timeSeriesCollection.removeSeries(timeSeries2);
        boolean bl5 = timeSeriesCollection.equals(timeSeriesCollection2);
        TimeSeriesCollectionTests.assertTrue((String)"b5", (boolean)bl5);
    }

    public void testRemoveSeries() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries timeSeries = new TimeSeries("Series 1");
        TimeSeries timeSeries2 = new TimeSeries("Series 2");
        TimeSeries timeSeries3 = new TimeSeries("Series 3");
        TimeSeries timeSeries4 = new TimeSeries("Series 4");
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.addSeries(timeSeries2);
        timeSeriesCollection.addSeries(timeSeries3);
        timeSeriesCollection.addSeries(timeSeries4);
        timeSeriesCollection.removeSeries(timeSeries3);
        TimeSeries timeSeries5 = timeSeriesCollection.getSeries(2);
        boolean bl = timeSeries5.equals(timeSeries4);
        TimeSeriesCollectionTests.assertTrue((boolean)bl);
    }

    public void testGetSurroundingItems() {
        TimeSeries timeSeries = new TimeSeries("Series 1", Day.class);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        timeSeriesCollection.setXPosition(TimePeriodAnchor.MIDDLE);
        int[] nArray = timeSeriesCollection.getSurroundingItems(0, 1000L);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == -1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == -1 ? 1 : 0) != 0);
        Day day = new Day();
        long l = day.getFirstMillisecond();
        long l2 = day.getMiddleMillisecond();
        long l3 = day.getLastMillisecond();
        timeSeries.add((RegularTimePeriod)day, 99.9);
        nArray = timeSeriesCollection.getSurroundingItems(0, l);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == -1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == 0 ? 1 : 0) != 0);
        nArray = timeSeriesCollection.getSurroundingItems(0, l2);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == 0 ? 1 : 0) != 0);
        nArray = timeSeriesCollection.getSurroundingItems(0, l3);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == -1 ? 1 : 0) != 0);
        Day day2 = (Day)day.next();
        long l4 = day2.getFirstMillisecond();
        long l5 = day2.getMiddleMillisecond();
        long l6 = day2.getLastMillisecond();
        timeSeries.add((RegularTimePeriod)day2, 199.9);
        nArray = timeSeriesCollection.getSurroundingItems(0, l4);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == 1 ? 1 : 0) != 0);
        nArray = timeSeriesCollection.getSurroundingItems(0, l5);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == 1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == 1 ? 1 : 0) != 0);
        nArray = timeSeriesCollection.getSurroundingItems(0, l6);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == 1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == -1 ? 1 : 0) != 0);
        Day day3 = (Day)day.previous();
        long l7 = day3.getFirstMillisecond();
        long l8 = day3.getMiddleMillisecond();
        long l9 = day3.getLastMillisecond();
        timeSeries.add((RegularTimePeriod)day3, 1.23);
        nArray = timeSeriesCollection.getSurroundingItems(0, l7);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == -1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == 0 ? 1 : 0) != 0);
        nArray = timeSeriesCollection.getSurroundingItems(0, l8);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == 0 ? 1 : 0) != 0);
        nArray = timeSeriesCollection.getSurroundingItems(0, l9);
        TimeSeriesCollectionTests.assertTrue((nArray[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((nArray[1] == 1 ? 1 : 0) != 0);
    }

    public void testSerialization() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(this.createSeries());
        TimeSeriesCollection timeSeriesCollection2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(timeSeriesCollection);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            timeSeriesCollection2 = (TimeSeriesCollection)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TimeSeriesCollectionTests.assertEquals((Object)timeSeriesCollection, timeSeriesCollection2);
    }

    private TimeSeries createSeries() {
        RegularTimePeriod regularTimePeriod = new Day();
        TimeSeries timeSeries = new TimeSeries("Test");
        timeSeries.add(regularTimePeriod, 1.0);
        regularTimePeriod = regularTimePeriod.next();
        timeSeries.add(regularTimePeriod, 2.0);
        regularTimePeriod = regularTimePeriod.next();
        timeSeries.add(regularTimePeriod, null);
        regularTimePeriod = regularTimePeriod.next();
        timeSeries.add(regularTimePeriod, 4.0);
        return timeSeries;
    }

    public void test1170825() {
        TimeSeries timeSeries = new TimeSeries("Series1");
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        try {
            timeSeriesCollection.getSeries(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            TimeSeriesCollectionTests.assertTrue((boolean)false);
        }
    }
}

