/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;

public class TimePeriodValuesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TimePeriodValuesCollectionTests.class);
    }

    public TimePeriodValuesCollectionTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void test1161340() {
        TimePeriodValuesCollection timePeriodValuesCollection = new TimePeriodValuesCollection();
        TimePeriodValues timePeriodValues = new TimePeriodValues("V1");
        timePeriodValues.add((TimePeriod)new Day(11, 3, 2005), 1.2);
        timePeriodValues.add((TimePeriod)new Day(12, 3, 2005), 3.4);
        timePeriodValuesCollection.addSeries(timePeriodValues);
        TimePeriodValuesCollectionTests.assertEquals((int)1, (int)timePeriodValuesCollection.getSeriesCount());
        timePeriodValuesCollection.removeSeries(timePeriodValues);
        TimePeriodValuesCollectionTests.assertEquals((int)0, (int)timePeriodValuesCollection.getSeriesCount());
        TimePeriodValues timePeriodValues2 = new TimePeriodValues("V2");
        timePeriodValues.add((TimePeriod)new Day(5, 3, 2005), 1.2);
        timePeriodValues.add((TimePeriod)new Day(6, 3, 2005), 3.4);
        timePeriodValuesCollection.addSeries(timePeriodValues2);
        TimePeriodValuesCollectionTests.assertEquals((int)1, (int)timePeriodValuesCollection.getSeriesCount());
    }

    public void testEquals() {
        TimePeriodValuesCollection timePeriodValuesCollection = new TimePeriodValuesCollection();
        TimePeriodValuesCollection timePeriodValuesCollection2 = new TimePeriodValuesCollection();
        TimePeriodValuesCollectionTests.assertTrue((boolean)timePeriodValuesCollection.equals(timePeriodValuesCollection2));
        timePeriodValuesCollection.setDomainIsPointsInTime(!timePeriodValuesCollection.getDomainIsPointsInTime());
        TimePeriodValuesCollectionTests.assertFalse((boolean)timePeriodValuesCollection.equals(timePeriodValuesCollection2));
        timePeriodValuesCollection2.setDomainIsPointsInTime(timePeriodValuesCollection.getDomainIsPointsInTime());
        TimePeriodValuesCollectionTests.assertTrue((boolean)timePeriodValuesCollection.equals(timePeriodValuesCollection2));
        timePeriodValuesCollection.setXPosition(TimePeriodAnchor.END);
        TimePeriodValuesCollectionTests.assertFalse((boolean)timePeriodValuesCollection.equals(timePeriodValuesCollection2));
        timePeriodValuesCollection2.setXPosition(TimePeriodAnchor.END);
        TimePeriodValuesCollectionTests.assertTrue((boolean)timePeriodValuesCollection.equals(timePeriodValuesCollection2));
        TimePeriodValues timePeriodValues = new TimePeriodValues("Test");
        TimePeriodValues timePeriodValues2 = new TimePeriodValues("Test");
        timePeriodValuesCollection.addSeries(timePeriodValues);
        TimePeriodValuesCollectionTests.assertFalse((boolean)timePeriodValuesCollection.equals(timePeriodValuesCollection2));
        timePeriodValuesCollection2.addSeries(timePeriodValues2);
        TimePeriodValuesCollectionTests.assertTrue((boolean)timePeriodValuesCollection.equals(timePeriodValuesCollection2));
    }

    public void testSerialization() {
        TimePeriodValuesCollection timePeriodValuesCollection = new TimePeriodValuesCollection();
        TimePeriodValuesCollection timePeriodValuesCollection2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(timePeriodValuesCollection);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            timePeriodValuesCollection2 = (TimePeriodValuesCollection)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TimePeriodValuesCollectionTests.assertEquals((Object)timePeriodValuesCollection, timePeriodValuesCollection2);
    }
}

