/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.TimePeriodFormatException;

public class QuarterTests
extends TestCase {
    private Quarter q1Y1900;
    private Quarter q2Y1900;
    private Quarter q3Y9999;
    private Quarter q4Y9999;

    public static Test suite() {
        return new TestSuite(QuarterTests.class);
    }

    public QuarterTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.q1Y1900 = new Quarter(1, 1900);
        this.q2Y1900 = new Quarter(2, 1900);
        this.q3Y9999 = new Quarter(3, 9999);
        this.q4Y9999 = new Quarter(4, 9999);
    }

    public void testEqualsSelf() {
        Quarter quarter = new Quarter();
        QuarterTests.assertTrue((boolean)quarter.equals(quarter));
    }

    public void testEquals() {
        Quarter quarter = new Quarter(2, 2002);
        Quarter quarter2 = new Quarter(2, 2002);
        QuarterTests.assertTrue((boolean)quarter.equals(quarter2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Quarter quarter = new Quarter(new Date(1017619199999L), timeZone);
        Quarter quarter2 = new Quarter(new Date(1017619200000L), timeZone);
        QuarterTests.assertEquals((int)1, (int)quarter.getQuarter());
        QuarterTests.assertEquals((long)1017619199999L, (long)quarter.getLastMillisecond(timeZone));
        QuarterTests.assertEquals((int)2, (int)quarter2.getQuarter());
        QuarterTests.assertEquals((long)1017619200000L, (long)quarter2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Istanbul");
        Quarter quarter = new Quarter(new Date(1017608399999L), timeZone);
        Quarter quarter2 = new Quarter(new Date(1017608400000L), timeZone);
        QuarterTests.assertEquals((int)1, (int)quarter.getQuarter());
        QuarterTests.assertEquals((long)1017608399999L, (long)quarter.getLastMillisecond(timeZone));
        QuarterTests.assertEquals((int)2, (int)quarter2.getQuarter());
        QuarterTests.assertEquals((long)1017608400000L, (long)quarter2.getFirstMillisecond(timeZone));
    }

    public void testQ1Y1900Previous() {
        Quarter quarter = (Quarter)this.q1Y1900.previous();
        QuarterTests.assertNull((Object)quarter);
    }

    public void testQ1Y1900Next() {
        Quarter quarter = (Quarter)this.q1Y1900.next();
        QuarterTests.assertEquals((Object)this.q2Y1900, (Object)quarter);
    }

    public void testQ4Y9999Previous() {
        Quarter quarter = (Quarter)this.q4Y9999.previous();
        QuarterTests.assertEquals((Object)this.q3Y9999, (Object)quarter);
    }

    public void testQ4Y9999Next() {
        Quarter quarter = (Quarter)this.q4Y9999.next();
        QuarterTests.assertNull((Object)quarter);
    }

    public void testParseQuarter() {
        Quarter quarter = null;
        try {
            quarter = Quarter.parseQuarter("Q1-2000");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)1, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2000, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("2001-Q2");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)2, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2001, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("Q3, 2002");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)3, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2002, (int)quarter.getYear().getYear());
    }

    public void testSerialization() {
        Quarter quarter = new Quarter(4, 1999);
        Quarter quarter2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(quarter);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            quarter2 = (Quarter)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        QuarterTests.assertEquals((Object)quarter, quarter2);
    }

    public void testHashcode() {
        Quarter quarter = new Quarter(2, 2003);
        Quarter quarter2 = new Quarter(2, 2003);
        QuarterTests.assertTrue((boolean)quarter.equals(quarter2));
        int n = quarter.hashCode();
        int n2 = quarter2.hashCode();
        QuarterTests.assertEquals((int)n, (int)n2);
    }

    public void testNotCloneable() {
        Quarter quarter = new Quarter(2, 2003);
        QuarterTests.assertFalse((boolean)(quarter instanceof Cloneable));
    }
}

