/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class MovingAverageTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(MovingAverageTests.class);
    }

    public MovingAverageTests(String string) {
        super(string);
    }

    public void test1() {
        TimeSeries timeSeries = this.createDailyTimeSeries1();
        TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, "Moving Average", 3, 3);
        MovingAverageTests.assertEquals((int)7, (int)timeSeries2.getItemCount());
        double d = timeSeries2.getValue(0).doubleValue();
        MovingAverageTests.assertEquals((double)14.1, (double)d, (double)1.0E-10);
        d = timeSeries2.getValue(1).doubleValue();
        MovingAverageTests.assertEquals((double)13.4, (double)d, (double)1.0E-10);
        d = timeSeries2.getValue(2).doubleValue();
        MovingAverageTests.assertEquals((double)14.433333333333, (double)d, (double)1.0E-10);
        d = timeSeries2.getValue(3).doubleValue();
        MovingAverageTests.assertEquals((double)14.933333333333, (double)d, (double)1.0E-10);
        d = timeSeries2.getValue(4).doubleValue();
        MovingAverageTests.assertEquals((double)19.8, (double)d, (double)1.0E-10);
        d = timeSeries2.getValue(5).doubleValue();
        MovingAverageTests.assertEquals((double)15.25, (double)d, (double)1.0E-10);
        d = timeSeries2.getValue(6).doubleValue();
        MovingAverageTests.assertEquals((double)12.5, (double)d, (double)1.0E-10);
    }

    private TimeSeries createDailyTimeSeries1() {
        TimeSeries timeSeries = new TimeSeries("Series 1", Day.class);
        timeSeries.add((RegularTimePeriod)new Day(11, 8, 2003), 11.2);
        timeSeries.add((RegularTimePeriod)new Day(13, 8, 2003), 13.8);
        timeSeries.add((RegularTimePeriod)new Day(17, 8, 2003), 14.1);
        timeSeries.add((RegularTimePeriod)new Day(18, 8, 2003), 12.7);
        timeSeries.add((RegularTimePeriod)new Day(19, 8, 2003), 16.5);
        timeSeries.add((RegularTimePeriod)new Day(20, 8, 2003), 15.6);
        timeSeries.add((RegularTimePeriod)new Day(25, 8, 2003), 19.8);
        timeSeries.add((RegularTimePeriod)new Day(27, 8, 2003), 10.7);
        timeSeries.add((RegularTimePeriod)new Day(28, 8, 2003), 14.3);
        return timeSeries;
    }
}

