/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Month;
import org.jfree.data.time.TimePeriodFormatException;

public class MonthTests
extends TestCase {
    private Month jan1900;
    private Month feb1900;
    private Month nov9999;
    private Month dec9999;

    public static Test suite() {
        return new TestSuite(MonthTests.class);
    }

    public MonthTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.jan1900 = new Month(1, 1900);
        this.feb1900 = new Month(2, 1900);
        this.nov9999 = new Month(11, 9999);
        this.dec9999 = new Month(12, 9999);
    }

    public void testEqualsSelf() {
        Month month = new Month();
        MonthTests.assertTrue((boolean)month.equals(month));
    }

    public void testEquals() {
        Month month = new Month(5, 2002);
        Month month2 = new Month(5, 2002);
        MonthTests.assertTrue((boolean)month.equals(month2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Month month = new Month(new Date(951868799999L), timeZone);
        Month month2 = new Month(new Date(951868800000L), timeZone);
        MonthTests.assertEquals((int)2, (int)month.getMonth());
        MonthTests.assertEquals((long)951868799999L, (long)month.getLastMillisecond(timeZone));
        MonthTests.assertEquals((int)3, (int)month2.getMonth());
        MonthTests.assertEquals((long)951868800000L, (long)month2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Pacific/Auckland");
        Month month = new Month(new Date(951821999999L), timeZone);
        Month month2 = new Month(new Date(951822000000L), timeZone);
        MonthTests.assertEquals((int)2, (int)month.getMonth());
        MonthTests.assertEquals((long)951821999999L, (long)month.getLastMillisecond(timeZone));
        MonthTests.assertEquals((int)3, (int)month2.getMonth());
        MonthTests.assertEquals((long)951822000000L, (long)month2.getFirstMillisecond(timeZone));
    }

    public void testJan1900Previous() {
        Month month = (Month)this.jan1900.previous();
        MonthTests.assertNull((Object)month);
    }

    public void testJan1900Next() {
        Month month = (Month)this.jan1900.next();
        MonthTests.assertEquals((Object)this.feb1900, (Object)month);
    }

    public void testDec9999Previous() {
        Month month = (Month)this.dec9999.previous();
        MonthTests.assertEquals((Object)this.nov9999, (Object)month);
    }

    public void testDec9999Next() {
        Month month = (Month)this.dec9999.next();
        MonthTests.assertNull((Object)month);
    }

    public void testParseMonth() {
        Month month = null;
        try {
            month = Month.parseMonth("1990-01");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            month = new Month(1, 1900);
        }
        MonthTests.assertEquals((int)1, (int)month.getMonth());
        MonthTests.assertEquals((int)1990, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("02-1991");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            month = new Month(1, 1900);
        }
        MonthTests.assertEquals((int)2, (int)month.getMonth());
        MonthTests.assertEquals((int)1991, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("March 1993");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            month = new Month(1, 1900);
        }
        MonthTests.assertEquals((int)3, (int)month.getMonth());
        MonthTests.assertEquals((int)1993, (int)month.getYear().getYear());
    }

    public void testSerialization() {
        Month month = new Month(12, 1999);
        Month month2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(month);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            month2 = (Month)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        MonthTests.assertEquals((Object)month, month2);
    }

    public void testHashcode() {
        Month month = new Month(2, 2003);
        Month month2 = new Month(2, 2003);
        MonthTests.assertTrue((boolean)month.equals(month2));
        int n = month.hashCode();
        int n2 = month2.hashCode();
        MonthTests.assertEquals((int)n, (int)n2);
    }

    public void testNotCloneable() {
        Month month = new Month(2, 2003);
        MonthTests.assertFalse((boolean)(month instanceof Cloneable));
    }
}

