/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Second;

public class MillisecondTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MillisecondTests.class);
    }

    public MillisecondTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Millisecond millisecond = new Millisecond();
        MillisecondTests.assertTrue((boolean)millisecond.equals(millisecond));
    }

    public void testEquals() {
        Day day = new Day(29, 3, 2002);
        Hour hour = new Hour(15, day);
        Minute minute = new Minute(15, hour);
        Second second = new Second(34, minute);
        Millisecond millisecond = new Millisecond(999, second);
        Day day2 = new Day(29, 3, 2002);
        Hour hour2 = new Hour(15, day2);
        Minute minute2 = new Minute(15, hour2);
        Second second2 = new Second(34, minute2);
        Millisecond millisecond2 = new Millisecond(999, second2);
        MillisecondTests.assertTrue((boolean)millisecond.equals(millisecond2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Millisecond millisecond = new Millisecond(new Date(1016729759122L), timeZone);
        Millisecond millisecond2 = new Millisecond(new Date(1016729759123L), timeZone);
        MillisecondTests.assertEquals((long)122L, (long)millisecond.getMillisecond());
        MillisecondTests.assertEquals((long)1016729759122L, (long)millisecond.getLastMillisecond(timeZone));
        MillisecondTests.assertEquals((long)123L, (long)millisecond2.getMillisecond());
        MillisecondTests.assertEquals((long)1016729759123L, (long)millisecond2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Tallinn");
        Millisecond millisecond = new Millisecond(new Date(1016722559122L), timeZone);
        Millisecond millisecond2 = new Millisecond(new Date(1016722559123L), timeZone);
        MillisecondTests.assertEquals((long)122L, (long)millisecond.getMillisecond());
        MillisecondTests.assertEquals((long)1016722559122L, (long)millisecond.getLastMillisecond(timeZone));
        MillisecondTests.assertEquals((long)123L, (long)millisecond2.getMillisecond());
        MillisecondTests.assertEquals((long)1016722559123L, (long)millisecond2.getFirstMillisecond(timeZone));
    }

    public void testSerialization() {
        Millisecond millisecond = new Millisecond();
        Millisecond millisecond2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(millisecond);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            millisecond2 = (Millisecond)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        MillisecondTests.assertEquals((Object)millisecond, millisecond2);
    }

    public void testHashcode() {
        Millisecond millisecond = new Millisecond(599, 23, 45, 7, 9, 10, 2007);
        Millisecond millisecond2 = new Millisecond(599, 23, 45, 7, 9, 10, 2007);
        MillisecondTests.assertTrue((boolean)millisecond.equals(millisecond2));
        int n = millisecond.hashCode();
        int n2 = millisecond2.hashCode();
        MillisecondTests.assertEquals((int)n, (int)n2);
    }

    public void test943985() {
        Millisecond millisecond = new Millisecond(new Date(4L));
        MillisecondTests.assertEquals((long)millisecond.getFirstMillisecond(), (long)millisecond.getMiddleMillisecond());
        MillisecondTests.assertEquals((long)millisecond.getMiddleMillisecond(), (long)millisecond.getLastMillisecond());
        millisecond = new Millisecond(new Date(5L));
        MillisecondTests.assertEquals((long)millisecond.getFirstMillisecond(), (long)millisecond.getMiddleMillisecond());
        MillisecondTests.assertEquals((long)millisecond.getMiddleMillisecond(), (long)millisecond.getLastMillisecond());
    }

    public void testNotCloneable() {
        Millisecond millisecond = new Millisecond(599, 23, 45, 7, 9, 10, 2007);
        MillisecondTests.assertFalse((boolean)(millisecond instanceof Cloneable));
    }
}

