/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;

public class HourTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(HourTests.class);
    }

    public HourTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Hour hour = new Hour();
        HourTests.assertTrue((boolean)hour.equals(hour));
    }

    public void testEquals() {
        Hour hour = new Hour(15, new Day(29, 3, 2002));
        Hour hour2 = new Hour(15, new Day(29, 3, 2002));
        HourTests.assertTrue((boolean)hour.equals(hour2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Hour hour = new Hour(new Date(1014307199999L), timeZone);
        Hour hour2 = new Hour(new Date(1014307200000L), timeZone);
        HourTests.assertEquals((int)15, (int)hour.getHour());
        HourTests.assertEquals((long)1014307199999L, (long)hour.getLastMillisecond(timeZone));
        HourTests.assertEquals((int)16, (int)hour2.getHour());
        HourTests.assertEquals((long)1014307200000L, (long)hour2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Australia/Sydney");
        Hour hour = new Hour(new Date(1014267599999L), timeZone);
        Hour hour2 = new Hour(new Date(1014267600000L), timeZone);
        HourTests.assertEquals((int)15, (int)hour.getHour());
        HourTests.assertEquals((long)1014267599999L, (long)hour.getLastMillisecond(timeZone));
        HourTests.assertEquals((int)16, (int)hour2.getHour());
        HourTests.assertEquals((long)1014267600000L, (long)hour2.getFirstMillisecond(timeZone));
    }

    public void testFirstHourPrevious() {
        Hour hour = new Hour(0, new Day(1, 1, 1900));
        Hour hour2 = (Hour)hour.previous();
        HourTests.assertNull((Object)hour2);
    }

    public void testFirstHourNext() {
        Hour hour = new Hour(0, new Day(1, 1, 1900));
        Hour hour2 = (Hour)hour.next();
        HourTests.assertEquals((int)1, (int)hour2.getHour());
        HourTests.assertEquals((int)1900, (int)hour2.getYear());
    }

    public void testLastHourPrevious() {
        Hour hour = new Hour(23, new Day(31, 12, 9999));
        Hour hour2 = (Hour)hour.previous();
        HourTests.assertEquals((int)22, (int)hour2.getHour());
        HourTests.assertEquals((int)9999, (int)hour2.getYear());
    }

    public void testLastHourNext() {
        Hour hour = new Hour(23, new Day(31, 12, 9999));
        Hour hour2 = (Hour)hour.next();
        HourTests.assertNull((Object)hour2);
    }

    public void testParseHour() {
        Hour hour = Hour.parseHour("2002-01-29 13");
        HourTests.assertEquals((int)13, (int)hour.getHour());
    }

    public void testSerialization() {
        Hour hour = new Hour();
        Hour hour2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(hour);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            hour2 = (Hour)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        HourTests.assertEquals((Object)hour, hour2);
    }

    public void testHashcode() {
        Hour hour = new Hour(7, 9, 10, 1999);
        Hour hour2 = new Hour(7, 9, 10, 1999);
        HourTests.assertTrue((boolean)hour.equals(hour2));
        int n = hour.hashCode();
        int n2 = hour2.hashCode();
        HourTests.assertEquals((int)n, (int)n2);
    }

    public void testNotCloneable() {
        Hour hour = new Hour(7, 9, 10, 1999);
        HourTests.assertFalse((boolean)(hour instanceof Cloneable));
    }
}

