/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.DateRange;

public class DateRangeTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DateRangeTests.class);
    }

    public DateRangeTests(String string) {
        super(string);
    }

    public void testEquals() {
        DateRange dateRange = new DateRange(new Date(1000L), new Date(2000L));
        DateRange dateRange2 = new DateRange(new Date(1000L), new Date(2000L));
        DateRangeTests.assertTrue((boolean)dateRange.equals(dateRange2));
        DateRangeTests.assertTrue((boolean)dateRange2.equals(dateRange));
        dateRange = new DateRange(new Date(1111L), new Date(2000L));
        DateRangeTests.assertFalse((boolean)dateRange.equals(dateRange2));
        dateRange2 = new DateRange(new Date(1111L), new Date(2000L));
        DateRangeTests.assertTrue((boolean)dateRange.equals(dateRange2));
        dateRange = new DateRange(new Date(1111L), new Date(2222L));
        DateRangeTests.assertFalse((boolean)dateRange.equals(dateRange2));
        dateRange2 = new DateRange(new Date(1111L), new Date(2222L));
        DateRangeTests.assertTrue((boolean)dateRange.equals(dateRange2));
    }

    public void testSerialization() {
        DateRange dateRange = new DateRange(new Date(1000L), new Date(2000L));
        DateRange dateRange2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(dateRange);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            dateRange2 = (DateRange)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DateRangeTests.assertEquals((Object)dateRange, dateRange2);
    }

    public void testClone() {
        DateRange dateRange = new DateRange(new Date(1000L), new Date(2000L));
        DateRangeTests.assertFalse((boolean)(dateRange instanceof Cloneable));
    }
}

