/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.SimpleHistogramBin;
import org.jfree.data.statistics.SimpleHistogramDataset;

public class SimpleHistogramDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SimpleHistogramDatasetTests.class);
    }

    public SimpleHistogramDatasetTests(String string) {
        super(string);
    }

    public void testEquals() {
        SimpleHistogramDataset simpleHistogramDataset = new SimpleHistogramDataset((Comparable)((Object)"Dataset 1"));
        SimpleHistogramDataset simpleHistogramDataset2 = new SimpleHistogramDataset((Comparable)((Object)"Dataset 1"));
        SimpleHistogramDatasetTests.assertTrue((boolean)simpleHistogramDataset.equals(simpleHistogramDataset2));
        simpleHistogramDataset.addBin(new SimpleHistogramBin(1.0, 2.0));
        SimpleHistogramDatasetTests.assertFalse((boolean)simpleHistogramDataset.equals(simpleHistogramDataset2));
        simpleHistogramDataset2.addBin(new SimpleHistogramBin(1.0, 2.0));
        SimpleHistogramDatasetTests.assertTrue((boolean)simpleHistogramDataset.equals(simpleHistogramDataset2));
    }

    public void testCloning() {
        SimpleHistogramDataset simpleHistogramDataset = new SimpleHistogramDataset((Comparable)((Object)"Dataset 1"));
        SimpleHistogramDataset simpleHistogramDataset2 = null;
        try {
            simpleHistogramDataset2 = (SimpleHistogramDataset)simpleHistogramDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        SimpleHistogramDatasetTests.assertTrue((simpleHistogramDataset != simpleHistogramDataset2 ? 1 : 0) != 0);
        SimpleHistogramDatasetTests.assertTrue((simpleHistogramDataset.getClass() == simpleHistogramDataset2.getClass() ? 1 : 0) != 0);
        SimpleHistogramDatasetTests.assertTrue((boolean)simpleHistogramDataset.equals(simpleHistogramDataset2));
        simpleHistogramDataset2.addBin(new SimpleHistogramBin(2.0, 3.0));
        simpleHistogramDataset2.addObservation(2.3);
        SimpleHistogramDatasetTests.assertFalse((boolean)simpleHistogramDataset.equals(simpleHistogramDataset2));
    }

    public void testSerialization() {
        SimpleHistogramDataset simpleHistogramDataset = new SimpleHistogramDataset((Comparable)((Object)"D1"));
        SimpleHistogramDataset simpleHistogramDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(simpleHistogramDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            simpleHistogramDataset2 = (SimpleHistogramDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SimpleHistogramDatasetTests.assertEquals((Object)simpleHistogramDataset, simpleHistogramDataset2);
    }
}

