/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RegressionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(RegressionTests.class);
    }

    public RegressionTests(String string) {
        super(string);
    }

    public void testOLSRegression1a() {
        double[][] dArray = this.createSampleData1();
        double[] dArray2 = Regression.getOLSRegression(dArray);
        RegressionTests.assertEquals((double)0.2568093, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.72792106, (double)dArray2[1], (double)1.0E-7);
    }

    public void testOLSRegression1b() {
        double[][] dArray = this.createSampleData1();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 11; ++i) {
            xYSeries.add(dArray[i][0], dArray[i][1]);
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        double[] dArray2 = Regression.getOLSRegression(xYSeriesCollection, 0);
        RegressionTests.assertEquals((double)0.2568093, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.72792106, (double)dArray2[1], (double)1.0E-7);
    }

    public void testPowerRegression1a() {
        double[][] dArray = this.createSampleData1();
        double[] dArray2 = Regression.getPowerRegression(dArray);
        RegressionTests.assertEquals((double)0.91045813, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.88918346, (double)dArray2[1], (double)1.0E-7);
    }

    public void testPowerRegression1b() {
        double[][] dArray = this.createSampleData1();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 11; ++i) {
            xYSeries.add(dArray[i][0], dArray[i][1]);
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        double[] dArray2 = Regression.getPowerRegression(xYSeriesCollection, 0);
        RegressionTests.assertEquals((double)0.91045813, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)0.88918346, (double)dArray2[1], (double)1.0E-7);
    }

    public void testOLSRegression2a() {
        double[][] dArray = this.createSampleData2();
        double[] dArray2 = Regression.getOLSRegression(dArray);
        RegressionTests.assertEquals((double)53.9729697, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-4.182303, (double)dArray2[1], (double)1.0E-7);
    }

    public void testOLSRegression2b() {
        double[][] dArray = this.createSampleData2();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 10; ++i) {
            xYSeries.add(dArray[i][0], dArray[i][1]);
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        double[] dArray2 = Regression.getOLSRegression(xYSeriesCollection, 0);
        RegressionTests.assertEquals((double)53.9729697, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-4.182303, (double)dArray2[1], (double)1.0E-7);
    }

    public void testPowerRegression2a() {
        double[][] dArray = this.createSampleData2();
        double[] dArray2 = Regression.getPowerRegression(dArray);
        RegressionTests.assertEquals((double)106.1241681, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-0.8466615, (double)dArray2[1], (double)1.0E-7);
    }

    public void testPowerRegression2b() {
        double[][] dArray = this.createSampleData2();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Test"));
        for (int i = 0; i < 10; ++i) {
            xYSeries.add(dArray[i][0], dArray[i][1]);
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        double[] dArray2 = Regression.getPowerRegression(xYSeriesCollection, 0);
        RegressionTests.assertEquals((double)106.1241681, (double)dArray2[0], (double)1.0E-7);
        RegressionTests.assertEquals((double)-0.8466615, (double)dArray2[1], (double)1.0E-7);
    }

    private double[][] createSampleData1() {
        double[][] dArray = new double[11][2];
        dArray[0][0] = 2.0;
        dArray[0][1] = 1.6;
        dArray[1][0] = 2.25;
        dArray[1][1] = 2.0;
        dArray[2][0] = 2.6;
        dArray[2][1] = 1.8;
        dArray[3][0] = 2.65;
        dArray[3][1] = 2.8;
        dArray[4][0] = 2.8;
        dArray[4][1] = 2.1;
        dArray[5][0] = 3.1;
        dArray[5][1] = 2.0;
        dArray[6][0] = 2.9;
        dArray[6][1] = 2.65;
        dArray[7][0] = 3.25;
        dArray[7][1] = 2.25;
        dArray[8][0] = 3.3;
        dArray[8][1] = 2.6;
        dArray[9][0] = 3.6;
        dArray[9][1] = 3.0;
        dArray[10][0] = 3.25;
        dArray[10][1] = 3.1;
        return dArray;
    }

    private double[][] createSampleData2() {
        double[][] dArray = new double[10][2];
        dArray[0][0] = 2.0;
        dArray[0][1] = 56.27;
        dArray[1][0] = 3.0;
        dArray[1][1] = 41.32;
        dArray[2][0] = 4.0;
        dArray[2][1] = 31.45;
        dArray[3][0] = 5.0;
        dArray[3][1] = 30.05;
        dArray[4][0] = 6.0;
        dArray[4][1] = 24.69;
        dArray[5][0] = 7.0;
        dArray[5][1] = 19.78;
        dArray[6][0] = 8.0;
        dArray[6][1] = 20.94;
        dArray[7][0] = 9.0;
        dArray[7][1] = 16.73;
        dArray[8][0] = 10.0;
        dArray[8][1] = 14.21;
        dArray[9][0] = 11.0;
        dArray[9][1] = 12.44;
        return dArray;
    }
}

