/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.HistogramBin;

public class HistogramBinTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(HistogramBinTests.class);
    }

    public HistogramBinTests(String string) {
        super(string);
    }

    public void testEquals() {
        double d = 10.0;
        double d2 = 20.0;
        HistogramBin histogramBin = new HistogramBin(d, d2);
        HistogramBin histogramBin2 = new HistogramBin(d, d2);
        HistogramBinTests.assertTrue((boolean)histogramBin.equals(histogramBin2));
        HistogramBinTests.assertTrue((boolean)histogramBin2.equals(histogramBin));
    }

    public void testCloning() {
        double d = 10.0;
        double d2 = 20.0;
        HistogramBin histogramBin = new HistogramBin(d, d2);
        HistogramBin histogramBin2 = null;
        try {
            histogramBin2 = (HistogramBin)histogramBin.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        HistogramBinTests.assertTrue((histogramBin != histogramBin2 ? 1 : 0) != 0);
        HistogramBinTests.assertTrue((histogramBin.getClass() == histogramBin2.getClass() ? 1 : 0) != 0);
        HistogramBinTests.assertTrue((boolean)histogramBin.equals(histogramBin2));
    }

    public void testSerialization() {
        double d = 10.0;
        double d2 = 20.0;
        HistogramBin histogramBin = new HistogramBin(d, d2);
        HistogramBin histogramBin2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(histogramBin);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            histogramBin2 = (HistogramBin)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        HistogramBinTests.assertEquals((Object)histogramBin, histogramBin2);
    }
}

