/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;

public class BoxAndWhiskerCalculatorTests
extends TestCase {
    private static final double EPSILON = 1.0E-9;

    public static Test suite() {
        return new TestSuite(BoxAndWhiskerCalculatorTests.class);
    }

    public BoxAndWhiskerCalculatorTests(String string) {
        super(string);
    }

    public void testCalculateQ1() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = BoxAndWhiskerCalculator.calculateQ1(arrayList);
        BoxAndWhiskerCalculatorTests.assertTrue((boolean)Double.isNaN(d));
        arrayList.add(new Double(1.0));
        d = BoxAndWhiskerCalculator.calculateQ1(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)1.0, (double)1.0E-9);
        arrayList.add(new Double(2.0));
        d = BoxAndWhiskerCalculator.calculateQ1(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)1.0, (double)1.0E-9);
        arrayList.add(new Double(3.0));
        d = BoxAndWhiskerCalculator.calculateQ1(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)1.5, (double)1.0E-9);
        arrayList.add(new Double(4.0));
        d = BoxAndWhiskerCalculator.calculateQ1(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)1.5, (double)1.0E-9);
    }

    public void testCalculateQ3() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = BoxAndWhiskerCalculator.calculateQ3(arrayList);
        BoxAndWhiskerCalculatorTests.assertTrue((boolean)Double.isNaN(d));
        arrayList.add(new Double(1.0));
        d = BoxAndWhiskerCalculator.calculateQ3(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)1.0, (double)1.0E-9);
        arrayList.add(new Double(2.0));
        d = BoxAndWhiskerCalculator.calculateQ3(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)2.0, (double)1.0E-9);
        arrayList.add(new Double(3.0));
        d = BoxAndWhiskerCalculator.calculateQ3(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)2.5, (double)1.0E-9);
        arrayList.add(new Double(4.0));
        d = BoxAndWhiskerCalculator.calculateQ3(arrayList);
        BoxAndWhiskerCalculatorTests.assertEquals((double)d, (double)3.5, (double)1.0E-9);
    }
}

