/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import org.jfree.util.PublicCloneable;

public class SimpleHistogramBin
implements Comparable,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 3480862537505941742L;
    private double lowerBound;
    private double upperBound;
    private boolean includeLowerBound;
    private boolean includeUpperBound;
    private int itemCount;

    public SimpleHistogramBin(double d, double d2) {
        this(d, d2, true, true);
    }

    public SimpleHistogramBin(double d, double d2, boolean bl, boolean bl2) {
        if (d >= d2) {
            throw new IllegalArgumentException("Invalid bounds");
        }
        this.lowerBound = d;
        this.upperBound = d2;
        this.includeLowerBound = bl;
        this.includeUpperBound = bl2;
        this.itemCount = 0;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int n) {
        this.itemCount = n;
    }

    public boolean accepts(double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        if (d < this.lowerBound) {
            return false;
        }
        if (d > this.upperBound) {
            return false;
        }
        if (d == this.lowerBound) {
            return this.includeLowerBound;
        }
        if (d == this.upperBound) {
            return this.includeUpperBound;
        }
        return true;
    }

    public boolean overlapsWith(SimpleHistogramBin simpleHistogramBin) {
        if (this.upperBound < simpleHistogramBin.lowerBound) {
            return false;
        }
        if (this.lowerBound > simpleHistogramBin.upperBound) {
            return false;
        }
        if (this.upperBound == simpleHistogramBin.lowerBound) {
            return this.includeUpperBound && simpleHistogramBin.includeLowerBound;
        }
        if (this.lowerBound == simpleHistogramBin.upperBound) {
            return this.includeLowerBound && simpleHistogramBin.includeUpperBound;
        }
        return true;
    }

    public int compareTo(Object object) {
        if (!(object instanceof SimpleHistogramBin)) {
            return 0;
        }
        SimpleHistogramBin simpleHistogramBin = (SimpleHistogramBin)object;
        if (this.lowerBound < simpleHistogramBin.lowerBound) {
            return -1;
        }
        if (this.lowerBound > simpleHistogramBin.lowerBound) {
            return 1;
        }
        if (this.upperBound < simpleHistogramBin.upperBound) {
            return -1;
        }
        if (this.upperBound > simpleHistogramBin.upperBound) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleHistogramBin)) {
            return false;
        }
        SimpleHistogramBin simpleHistogramBin = (SimpleHistogramBin)object;
        if (this.lowerBound != simpleHistogramBin.lowerBound) {
            return false;
        }
        if (this.upperBound != simpleHistogramBin.upperBound) {
            return false;
        }
        if (this.includeLowerBound != simpleHistogramBin.includeLowerBound) {
            return false;
        }
        if (this.includeUpperBound != simpleHistogramBin.includeUpperBound) {
            return false;
        }
        return this.itemCount == simpleHistogramBin.itemCount;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

