/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.util.SortOrder;

public class DefaultKeyedValuesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValuesTests.class);
    }

    public DefaultKeyedValuesTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testGetValue() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        try {
            defaultKeyedValues.getValue(-1);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            defaultKeyedValues.getValue(0);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        defaultKeyedValues2.addValue((Comparable)((Object)"K1"), new Integer(1));
        defaultKeyedValues2.addValue((Comparable)((Object)"K2"), new Integer(2));
        defaultKeyedValues2.addValue((Comparable)((Object)"K3"), new Integer(3));
        DefaultKeyedValuesTests.assertEquals((Object)new Integer(3), (Object)defaultKeyedValues2.getValue(2));
    }

    public void testGetKey() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        try {
            defaultKeyedValues.getKey(-1);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            defaultKeyedValues.getKey(0);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        defaultKeyedValues2.addValue((Comparable)((Object)"K1"), new Integer(1));
        defaultKeyedValues2.addValue((Comparable)((Object)"K2"), new Integer(2));
        defaultKeyedValues2.addValue((Comparable)((Object)"K3"), new Integer(3));
        DefaultKeyedValuesTests.assertEquals((Object)"K2", (Object)defaultKeyedValues2.getKey(1));
    }

    public void testGetIndex() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        DefaultKeyedValuesTests.assertEquals((int)-1, (int)defaultKeyedValues.getIndex((Comparable)((Object)"K1")));
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        defaultKeyedValues2.addValue((Comparable)((Object)"K1"), new Integer(1));
        defaultKeyedValues2.addValue((Comparable)((Object)"K2"), new Integer(2));
        defaultKeyedValues2.addValue((Comparable)((Object)"K3"), new Integer(3));
        DefaultKeyedValuesTests.assertEquals((int)2, (int)defaultKeyedValues2.getIndex((Comparable)((Object)"K3")));
    }

    public void testCloning() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"V1"), new Integer(1));
        defaultKeyedValues.addValue((Comparable)((Object)"V2"), null);
        defaultKeyedValues.addValue((Comparable)((Object)"V3"), new Integer(3));
        DefaultKeyedValues defaultKeyedValues2 = null;
        try {
            defaultKeyedValues2 = (DefaultKeyedValues)defaultKeyedValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValuesTests.assertTrue((defaultKeyedValues != defaultKeyedValues2 ? 1 : 0) != 0);
        DefaultKeyedValuesTests.assertTrue((defaultKeyedValues.getClass() == defaultKeyedValues2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValuesTests.assertTrue((boolean)defaultKeyedValues.equals(defaultKeyedValues2));
        defaultKeyedValues2.setValue((Comparable)((Object)"V1"), new Integer(44));
        DefaultKeyedValuesTests.assertFalse((boolean)defaultKeyedValues.equals(defaultKeyedValues2));
    }

    public void testInsertAndRetrieve() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"A"), new Double(1.0));
        defaultKeyedValues.addValue((Comparable)((Object)"B"), new Double(2.0));
        defaultKeyedValues.addValue((Comparable)((Object)"C"), new Double(3.0));
        defaultKeyedValues.addValue((Comparable)((Object)"D"), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(0), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(1), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(2), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(3), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"A")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"B")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"C")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"D")), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(0), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(1), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(2), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(3), null);
    }

    public void testSortByKeyAscending() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"C"), new Double(1.0));
        defaultKeyedValues.addValue((Comparable)((Object)"B"), null);
        defaultKeyedValues.addValue((Comparable)((Object)"D"), new Double(3.0));
        defaultKeyedValues.addValue((Comparable)((Object)"A"), new Double(2.0));
        defaultKeyedValues.sortByKeys(SortOrder.ASCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(0), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(1), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(2), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(3), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(0), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(1), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(2), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(3), (Object)new Double(3.0));
    }

    public void testSortByKeyDescending() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"C"), new Double(1.0));
        defaultKeyedValues.addValue((Comparable)((Object)"B"), null);
        defaultKeyedValues.addValue((Comparable)((Object)"D"), new Double(3.0));
        defaultKeyedValues.addValue((Comparable)((Object)"A"), new Double(2.0));
        defaultKeyedValues.sortByKeys(SortOrder.DESCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(0), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(1), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(2), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(3), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(0), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(1), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(2), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(3), (Object)new Double(2.0));
    }

    public void testSortByValueAscending() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"C"), new Double(1.0));
        defaultKeyedValues.addValue((Comparable)((Object)"B"), null);
        defaultKeyedValues.addValue((Comparable)((Object)"D"), new Double(3.0));
        defaultKeyedValues.addValue((Comparable)((Object)"A"), new Double(2.0));
        defaultKeyedValues.sortByValues(SortOrder.ASCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(0), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(1), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(2), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(3), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(0), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(1), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(2), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(3), null);
    }

    public void testSortByValueDescending() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"C"), new Double(1.0));
        defaultKeyedValues.addValue((Comparable)((Object)"B"), null);
        defaultKeyedValues.addValue((Comparable)((Object)"D"), new Double(3.0));
        defaultKeyedValues.addValue((Comparable)((Object)"A"), new Double(2.0));
        defaultKeyedValues.sortByValues(SortOrder.DESCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(0), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(1), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(2), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getKey(3), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(0), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(1), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(2), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues.getValue(3), null);
    }

    public void testSerialization() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"Key 1"), new Double(23.0));
        defaultKeyedValues.addValue((Comparable)((Object)"Key 2"), null);
        defaultKeyedValues.addValue((Comparable)((Object)"Key 3"), new Double(42.0));
        DefaultKeyedValues defaultKeyedValues2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultKeyedValues);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultKeyedValues2 = (DefaultKeyedValues)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultKeyedValuesTests.assertEquals((Object)defaultKeyedValues, defaultKeyedValues2);
    }
}

