/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValues2D;

public class DefaultKeyedValues2DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValues2DTests.class);
    }

    public DefaultKeyedValues2DTests(String string) {
        super(string);
    }

    public void testCloning() {
        DefaultKeyedValues2D defaultKeyedValues2D = new DefaultKeyedValues2D();
        defaultKeyedValues2D.setValue(new Integer(1), (Comparable)((Object)"V1"), (Comparable)((Object)"C1"));
        defaultKeyedValues2D.setValue(null, (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        defaultKeyedValues2D.setValue(new Integer(3), (Comparable)((Object)"V3"), (Comparable)((Object)"C2"));
        DefaultKeyedValues2D defaultKeyedValues2D2 = null;
        try {
            defaultKeyedValues2D2 = (DefaultKeyedValues2D)defaultKeyedValues2D.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValues2DTests.assertTrue((defaultKeyedValues2D != defaultKeyedValues2D2 ? 1 : 0) != 0);
        DefaultKeyedValues2DTests.assertTrue((defaultKeyedValues2D.getClass() == defaultKeyedValues2D2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValues2DTests.assertTrue((boolean)defaultKeyedValues2D.equals(defaultKeyedValues2D2));
        defaultKeyedValues2D2.setValue(new Integer(2), (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        DefaultKeyedValues2DTests.assertFalse((boolean)defaultKeyedValues2D.equals(defaultKeyedValues2D2));
    }

    public void testSerialization() {
        DefaultKeyedValues2D defaultKeyedValues2D = new DefaultKeyedValues2D();
        defaultKeyedValues2D.addValue(new Double(234.2), (Comparable)((Object)"Row1"), (Comparable)((Object)"Col1"));
        defaultKeyedValues2D.addValue(null, (Comparable)((Object)"Row1"), (Comparable)((Object)"Col2"));
        defaultKeyedValues2D.addValue(new Double(345.9), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col1"));
        defaultKeyedValues2D.addValue(new Double(452.7), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col2"));
        DefaultKeyedValues2D defaultKeyedValues2D2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultKeyedValues2D);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultKeyedValues2D2 = (DefaultKeyedValues2D)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultKeyedValues2DTests.assertEquals((Object)defaultKeyedValues2D, defaultKeyedValues2D2);
    }
}

