/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValue;

public class DefaultKeyedValueTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValueTests.class);
    }

    public DefaultKeyedValueTests(String string) {
        super(string);
    }

    public void testEquals() {
        DefaultKeyedValue defaultKeyedValue = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValue defaultKeyedValue2 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValueTests.assertTrue((boolean)defaultKeyedValue.equals(defaultKeyedValue2));
        DefaultKeyedValueTests.assertTrue((boolean)defaultKeyedValue2.equals(defaultKeyedValue));
        defaultKeyedValue = new DefaultKeyedValue((Comparable)((Object)"Test 1"), new Double(45.5));
        defaultKeyedValue2 = new DefaultKeyedValue((Comparable)((Object)"Test 2"), new Double(45.5));
        DefaultKeyedValueTests.assertFalse((boolean)defaultKeyedValue.equals(defaultKeyedValue2));
        defaultKeyedValue = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        defaultKeyedValue2 = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.6));
        DefaultKeyedValueTests.assertFalse((boolean)defaultKeyedValue.equals(defaultKeyedValue2));
    }

    public void testCloning() {
        DefaultKeyedValue defaultKeyedValue = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValue defaultKeyedValue2 = null;
        try {
            defaultKeyedValue2 = (DefaultKeyedValue)defaultKeyedValue.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValueTests.assertTrue((defaultKeyedValue != defaultKeyedValue2 ? 1 : 0) != 0);
        DefaultKeyedValueTests.assertTrue((defaultKeyedValue.getClass() == defaultKeyedValue2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValueTests.assertTrue((boolean)defaultKeyedValue.equals(defaultKeyedValue2));
        defaultKeyedValue2.setValue(new Double(12.3));
        DefaultKeyedValueTests.assertFalse((boolean)defaultKeyedValue.equals(defaultKeyedValue2));
    }

    public void testSerialization() {
        DefaultKeyedValue defaultKeyedValue = new DefaultKeyedValue((Comparable)((Object)"Test"), new Double(25.3));
        DefaultKeyedValue defaultKeyedValue2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultKeyedValue);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultKeyedValue2 = (DefaultKeyedValue)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultKeyedValueTests.assertEquals((Object)defaultKeyedValue, defaultKeyedValue2);
    }
}

